/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hbase;

import eu.dnetlib.data.hadoop.hbase.HbaseTableFeeder;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

public class HBasePutFeeder
extends HbaseTableFeeder {
    private static final Log log = LogFactory.getLog(HBasePutFeeder.class);

    @Override
    protected void addOperation(List<Mutation> buffer, Row row) {
        Put put = new Put(Bytes.toBytes((String)row.getKey()));
        put.setWriteToWAL(true);
        for (Column col : row) {
            log.debug((Object)String.format("adding value to K: '%s' CF:'%s' Q:'%s'", row.getKey(), row.getColumnFamily(), col.getName()));
            put.add(Bytes.toBytes((String)row.getColumnFamily()), Bytes.toBytes((String)((String)col.getName())), (byte[])col.getValue());
        }
        buffer.add((Mutation)put);
    }
}

