package eu.dnetlib.data.hadoop.action;

import java.util.Date;

import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;

public abstract class JobMonitor implements Runnable {

	private final JobCompletion callback;

	protected Date lastActivity;

    /**
     * Monitor sleep time in seconds.
     */
    protected final int monitorSleepTimeSecs = 10;

	protected JobMonitor(JobCompletion callback) {
		this.callback = callback;
		this.lastActivity = new Date(System.currentTimeMillis());
	}

	@Override
	public abstract void run();

	public abstract void kill();

	public abstract String getStatus();

	public abstract Date getLastActivity();

	public abstract Date getStartTime() throws HadoopServiceException;

	public abstract String getHadoopId();

	public abstract String getTrackerUrl();

	protected JobCompletion getCallback() {
		return callback;
	}

}
