package eu.dnetlib.data.hadoop.hbase;

import eu.dnetlib.data.hadoop.AbstractHadoopClient;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class HBaseAdminFactory extends AbstractHadoopClient {

	private static final Log log = LogFactory.getLog(HBaseAdminFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	public HBaseAdmin newInstance(final ClusterName clusterName) throws HadoopServiceException {
		try {
			log.info("init hbaseAdmin, cluster: " + clusterName.toString());
			setHadoopUser();
			return new HBaseAdmin(configurationEnumerator.get(clusterName));
		} catch (final Throwable e) {
			throw new HadoopServiceException("unable to initialize hbase client for cluster: " + clusterName.toString(), e);
		}
	}

}
