package eu.dnetlib.data.hadoop.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.hbase.HbaseTableFeeder;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;

public class ImportEprHbaseAction extends AbstractHadoopAction {

	private static final Log log = LogFactory.getLog(ImportEprHbaseAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	private HbaseTableFeeder hbaseTableFeeder;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws HadoopServiceException {

		final String epr = DnetXsltFunctions.decodeBase64(job.getParameters().get("input_epr"));
		final String xsl = DnetXsltFunctions.decodeBase64(job.getParameters().get("xslt"));
		final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
		final String table = job.getParameters().get("table");
		final boolean simulation = Boolean.valueOf(job.getParameters().get("simulation"));

		log.info("Starting import in table " + table);

		try {
			final Integer count = getHbaseTableFeeder().feed(epr, xsl, clusterName, table, simulation);

			if (count != null) {
				log.info("Import completed successfully");
				job.getParameters().put("count", String.valueOf(count));
			}

			handler.done(job);
		} catch (final Throwable e) {
			log.error("Import failed", e);
			throw new HadoopServiceException("Import failed", e);
		}
	}

	public HbaseTableFeeder getHbaseTableFeeder() {
		return hbaseTableFeeder;
	}

	@Required
	public void setHbaseTableFeeder(final HbaseTableFeeder hbaseTableFeeder) {
		this.hbaseTableFeeder = hbaseTableFeeder;
	}

}
