package eu.dnetlib.data.hadoop.mapred;

import java.io.IOException;

import eu.dnetlib.data.hadoop.AbstractHadoopClient;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import org.apache.hadoop.mapred.JobClient;

/**
 * Factory bean for jobClient instances
 *
 * @author claudio
 *
 */
public class JobClientFactory extends AbstractHadoopClient {

	public JobClient newInstance(final ClusterName clusterName, final String userName) throws IOException {
		setHadoopUser(userName);
		return new JobClient(configurationEnumerator.get(clusterName));
	}

	public JobClient newInstance(final ClusterName clusterName) throws IOException, HadoopServiceException {
		setHadoopUser();
		return new JobClient(configurationEnumerator.get(clusterName));
	}

}
