package eu.dnetlib.data.hadoop.action;

import java.io.IOException;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;

public class ImportEprHdfsAction extends AbstractHadoopAction {

	private static final Log log = LogFactory.getLog(ImportEprHdfsAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	private SequenceFileFeeder sequenceFileFeeder;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws HadoopServiceException {

		final String epr = DnetXsltFunctions.decodeBase64(job.getParameters().get("input_epr"));
		final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
		final String path = job.getParameters().get("path");

		log.info(String.format("Starting import in hdfs sequence file '%s', cluster '%s', epr '%s...", path, clusterName.toString(),
				StringUtils.substring(epr, 0, 20)));
		try {
			Integer count = getSequenceFileFeeder().feed(epr, clusterName, path);
			if (count != null) {
				log.info("Import completed successfully");
				job.getParameters().put("count", String.valueOf(count));
			}

			handler.done(job);
		} catch (IOException e) {
			throw new HadoopServiceException("Import failed", e);
		}
	}

	public SequenceFileFeeder getSequenceFileFeeder() {
		return sequenceFileFeeder;
	}

	@Required
	public void setSequenceFileFeeder(final SequenceFileFeeder sequenceFileFeeder) {
		this.sequenceFileFeeder = sequenceFileFeeder;
	}

}
