package eu.dnetlib.data.hadoop.oozie;

import eu.dnetlib.data.hadoop.AbstractHadoopClient;
import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.client.OozieClient;

/**
 * Factory bean for Oozie client instances.
 * 
 * oozie server may not be available in every hadoop deployment, so every oozie specific operation should be defined as optional.
 * 
 * @author claudio
 * 
 */
public class OozieClientFactory extends AbstractHadoopClient {

	private static final String ENV_ATTRIBUTE_OOZIE_SERVICE_LOC = "oozie.service.loc";

	private static final Log log = LogFactory.getLog(OozieClientFactory.class); // NOPMD by marko on 11/24/08 5:02 PM

	public OozieClient newInstance(ClusterName clusterName) throws HadoopServiceException {
		final String oozieServiceLocation = configurationEnumerator.get(clusterName).get(ENV_ATTRIBUTE_OOZIE_SERVICE_LOC);
		log.info("init oozie client, cluster: " + clusterName.toString() + ", oozie server: " + oozieServiceLocation);
		setHadoopUser();
		try {
			return new OozieClient(oozieServiceLocation);
		} catch (Throwable e) {
			throw new HadoopServiceException("unable to initialize oozie client for cluster: " + clusterName.toString(), e);
		}
	}

}
