/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.query;

import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.provision.index.rmi.BrowsingRow;
import eu.dnetlib.data.provision.index.rmi.GroupResult;
import eu.dnetlib.functionality.index.query.QueryResponseParser;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class SolrResponseParser
extends QueryResponseParser {
    private static final Log log = LogFactory.getLog(SolrResponseParser.class);
    private QueryResponse queryRsp = null;
    protected final UnaryFunction<String, SolrDocument> wrapperRank = new UnaryFunction<String, SolrDocument>(){

        public String evaluate(SolrDocument doc) {
            return SolrResponseParser.this.addRanking(SolrResponseParser.this.getSingleField(doc, "__result"), SolrResponseParser.this.getSingleField(doc, "score"));
        }
    };
    protected final UnaryFunction<String, SolrDocument> wrapperNoRank = new UnaryFunction<String, SolrDocument>(){

        public String evaluate(SolrDocument doc) {
            return SolrResponseParser.this.wrap(SolrResponseParser.this.getSingleField(doc, "__result"));
        }
    };

    public SolrResponseParser(UnaryFunction<String, String> highlightUtils, BiMap<String, String> aliases, boolean returnEmptyFields, boolean includeRanking, QueryResponse response) {
        super(highlightUtils, aliases, returnEmptyFields, includeRanking);
        this.queryRsp = response;
    }

    public long getNumFound() {
        return this.queryRsp.getResults().getNumFound();
    }

    public int getQueryTime() {
        return this.queryRsp.getQTime();
    }

    public long getElapsedTime() {
        return this.queryRsp.getElapsedTime();
    }

    public String getStatus() {
        return String.valueOf(this.queryRsp.getStatus());
    }

    public int getCurrentSize() {
        return this.queryRsp.getResults().size();
    }

    public QueryResponse getQueryResponse() {
        return this.queryRsp;
    }

    public List<String> getResults() {
        return this.asRankedList(this.queryRsp.getResults());
    }

    public Long getNumberOfBrowsingResults() {
        List ffList = this.queryRsp.getFacetFields();
        Long maxCount = 0L;
        if (ffList != null) {
            for (FacetField ff : ffList) {
                Long countFacets;
                if (ff == null || (countFacets = this.countFacets(ff.getValues())) <= maxCount) continue;
                maxCount = countFacets;
            }
        }
        return maxCount;
    }

    public List<BrowsingRow> getBrowsingResults() {
        ArrayList bresList = Lists.newArrayList();
        ArrayList facets = Lists.newArrayList();
        List ffList = this.queryRsp.getFacetFields();
        Long numberOfBrowsingResults = this.getNumberOfBrowsingResults();
        int i = 0;
        while (ffList != null && (long)i < numberOfBrowsingResults) {
            for (FacetField ff : ffList) {
                FacetField.Count facet;
                String name = null;
                if (this.aliases != null) {
                    name = (String)this.aliases.inverse().get((Object)ff.getName());
                }
                if (name == null) {
                    name = ff.getName();
                }
                if ((facet = this.getFacet(ff, i)) == null || facet.getCount() <= 0L) continue;
                String value = facet.getName();
                int count = (int)facet.getCount();
                if (!this.returnEmptyFields && value.isEmpty()) continue;
                facets.add(new GroupResult(name, value, count));
            }
            if (facets.size() > 0) {
                bresList.add(new BrowsingRow((List)Lists.newArrayList((Iterable)facets)));
                facets.clear();
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BrowsingResult size: " + bresList.size()));
        }
        return bresList;
    }

    private FacetField.Count getFacet(FacetField ff, int pos) {
        if (ff.getValues() == null || pos >= ff.getValues().size()) {
            return null;
        }
        return (FacetField.Count)ff.getValues().get(pos);
    }

    private List<String> asRankedList(SolrDocumentList documentList) {
        UnaryFunction<String, SolrDocument> wrapper;
        UnaryFunction<String, SolrDocument> unaryFunction = wrapper = this.includeRanking ? this.wrapperRank : this.wrapperNoRank;
        if (this.queryRsp.getHighlighting() != null) {
            return MappedCollection.listMap((Iterable)MappedCollection.listMap((Iterable)documentList, (UnaryFunction)new UnaryFunction<String, SolrDocument>(){

                public String evaluate(SolrDocument doc) {
                    String score = SolrResponseParser.this.getSingleField(doc, "score");
                    String hl = SolrResponseParser.this.getHighlighting(SolrResponseParser.this.getSingleField(doc, "__indexrecordidentifier"));
                    String res = hl != null ? hl : SolrResponseParser.this.getSingleField(doc, "__result");
                    return SolrResponseParser.this.includeRanking ? SolrResponseParser.this.addRanking(res, score) : SolrResponseParser.this.wrap(res);
                }
            }), (UnaryFunction)this.highlightUtils);
        }
        return MappedCollection.listMap((Iterable)documentList, wrapper);
    }

    private String addRanking(String doc, String score) {
        return new String("<record rank=\"" + score + "\">" + doc + "</record>");
    }

    private String wrap(String doc) {
        return new String("<record>" + doc + "</record>");
    }

    protected String getSingleField(SolrDocument doc, String fieldName) {
        Object value = doc.getFieldValue(fieldName);
        if (value instanceof Collection) {
            return (String)Iterables.getOnlyElement((Iterable)((Iterable)value));
        }
        return String.valueOf(value);
    }

    private String getHighlighting(String docId) {
        Map highlight = (Map)this.queryRsp.getHighlighting().get(docId);
        String result = new String();
        if (highlight != null && highlight.get("__result") != null) {
            for (String s : (List)highlight.get("__result")) {
                result = result.concat(s);
            }
            return result;
        }
        return null;
    }

    private Long countFacets(List<FacetField.Count> facets) {
        if (facets == null) {
            return 0L;
        }
        return Iterables.size((Iterable)Iterables.filter(facets, (Predicate)new Predicate<FacetField.Count>(){

            public boolean apply(FacetField.Count c) {
                return c != null && c.getName() != null && !c.getName().isEmpty() && c.getCount() > 0L;
            }
        }));
    }

    public long getStart() {
        return this.queryRsp.getResults().getStart();
    }
}

