/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.cql;

import eu.dnetlib.functionality.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.index.model.Any;
import eu.dnetlib.miscutils.functional.IdentityFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;

public class SolrTypeBasedCqlValueTransformerMap
implements CqlValueTransformerMap {
    private static final Log log = LogFactory.getLog(SolrTypeBasedCqlValueTransformerMap.class);
    private final Map<String, Any.ValueType> schema;
    private final Map<String, UnaryFunction<String, String>> transformerMap;

    public SolrTypeBasedCqlValueTransformerMap(Map<String, Any.ValueType> schema, Map<String, UnaryFunction<String, String>> transformerMap) {
        this.schema = schema;
        this.transformerMap = transformerMap;
    }

    public UnaryFunction<String, String> transformerFor(String fieldName) {
        try {
            UnaryFunction<String, String> res;
            Any.ValueType field = this.schema.get(fieldName);
            if (field != null && (res = this.transformerMap.get(field.name())) != null) {
                return res;
            }
        }
        catch (SolrException e) {
            log.debug((Object)"cannot find field", (Throwable)e);
        }
        return new IdentityFunction();
    }
}

