/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.client.clients.solr;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import eu.dnetlib.data.provision.index.rmi.BrowsingRow;
import eu.dnetlib.data.provision.index.rmi.GroupResult;
import eu.dnetlib.functionality.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.index.client.AbstractIndexClient;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.response.BrowseEntry;
import eu.dnetlib.functionality.index.client.response.BrowseValueEntry;
import eu.dnetlib.functionality.index.client.response.LookupResponse;
import eu.dnetlib.functionality.index.model.Any;
import eu.dnetlib.functionality.index.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.query.IndexQueryResponse;
import eu.dnetlib.functionality.index.query.QueryLanguage;
import eu.dnetlib.functionality.index.query.QueryResponseFactory;
import eu.dnetlib.functionality.index.query.QueryResponseParser;
import eu.dnetlib.functionality.index.query.SolrIndexQuery;
import eu.dnetlib.functionality.index.query.SolrIndexQueryFactory;
import eu.dnetlib.functionality.index.query.SolrIndexQueryResponse;
import eu.dnetlib.functionality.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public class SolrIndexClient
extends AbstractIndexClient
implements IndexClient {
    private CloudSolrClient client;
    private SolrIndexQueryFactory solrIndexQueryFactory;
    private QueryResponseFactory<QueryResponse> queryResponseFactory;
    private SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;
    private static final Log log = LogFactory.getLog(SolrIndexClient.class);

    public SolrIndexClient(String format, String layout, String interpretation, Map<String, String> serviceProperties, SolrIndexQueryFactory indexQueryFactory, QueryResponseFactory<QueryResponse> queryResponseFactory, SolrTypeBasedCqlValueTransformerMapFactory tMapFactory) {
        super(format, layout, interpretation, serviceProperties);
        log.debug((Object)String.format("Created a new instance of the index of type %s-%s-%s", format, layout, interpretation));
        this.solrIndexQueryFactory = indexQueryFactory;
        this.queryResponseFactory = queryResponseFactory;
        this.tMapFactory = tMapFactory;
    }

    public long delete(String query) throws IndexClientException {
        try {
            log.debug((Object)("delete by query: " + query));
            MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
            SolrIndexQuery translatedQuery = (SolrIndexQuery)this.solrIndexQueryFactory.getIndexQuery(QueryLanguage.CQL, query, this, mdRef);
            String tquery = translatedQuery.getQuery();
            translatedQuery.setQueryLimit(0);
            SolrIndexQueryResponse rsp = new SolrIndexQueryResponse(this.client.query((SolrParams)translatedQuery));
            QueryResponseParser responseParser = this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)rsp, mdRef);
            long total = responseParser.getNumFound();
            this.client.deleteByQuery(tquery);
            this.client.commit();
            return total;
        }
        catch (Exception e) {
            throw new IndexClientException("unable to run delete by query: " + query, (Throwable)e);
        }
    }

    public List<BrowseEntry> browse(String query, List<String> browseFields, int max) throws IndexClientException {
        MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
        SolrIndexQuery translatedQuery = this.buildBrowseQuery(query, browseFields, max, mdRef);
        return this.executeBrowseQuery(query, translatedQuery, mdRef, browseFields);
    }

    public List<BrowseEntry> browse(String query, List<String> browseFields, int max, List<String> filterQuery) throws IndexClientException {
        MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
        SolrIndexQuery translatedQuery = this.buildBrowseQuery(query, browseFields, max, mdRef);
        if (filterQuery != null) {
            log.debug((Object)"Filter Query:");
            for (String fq : filterQuery) {
                translatedQuery.addFilterQuery(new String[]{fq});
                log.debug((Object)("- " + fq));
            }
        }
        return this.executeBrowseQuery(query, translatedQuery, mdRef, browseFields);
    }

    public SolrIndexQuery buildBrowseQuery(String query, List<String> browseFields, int max, MetadataReference mdRef) throws IndexClientException {
        log.debug((Object)("Browse request for the index collection for query:" + query));
        SolrIndexQuery translatedQuery = (SolrIndexQuery)this.solrIndexQueryFactory.getIndexQuery(QueryLanguage.CQL, query, this, mdRef);
        translatedQuery.setFacet(true);
        if (browseFields != null) {
            List browsableFields = this.solrIndexQueryFactory.getBrowsableFields(browseFields, mdRef);
            log.debug((Object)"Browsing fields:");
            for (String field : browsableFields) {
                translatedQuery.addFacetField(new String[]{field});
                log.debug((Object)("- " + field));
            }
            translatedQuery.setFacetLimit(max);
            log.debug((Object)("max number of browsing field :" + max));
        }
        return translatedQuery;
    }

    private List<BrowseEntry> executeBrowseQuery(String originalQuery, SolrIndexQuery query, MetadataReference mdRef, List<String> browseFields) throws IndexClientException {
        try {
            SolrIndexQueryResponse response = new SolrIndexQueryResponse(this.client.query((SolrParams)query));
            QueryResponseParser responseParser = this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)response, mdRef);
            List results = responseParser.getBrowsingResults();
            List<BrowseEntry> out = this.convertBrowseEntry(browseFields, results, (BiMap<String, String>)responseParser.getAliases());
            return out;
        }
        catch (IOException | SolrServerException e) {
            throw new IndexClientException("Error on executing a query " + originalQuery, e);
        }
    }

    private String getUrl() throws IndexClientException {
        String address = (String)this.serviceProperties.get(ZK_ADDRESS);
        if (address == null) {
            throw new IndexClientException("Unable to load a solr client, missing zk address");
        }
        return address;
    }

    public SolrClient getClient() throws IndexClientException {
        if (this.client == null) {
            String url = this.getUrl();
            log.debug((Object)("create new Client " + url));
            this.client = new CloudSolrClient.Builder().withZkHost(url).build();
            this.client.setDefaultCollection(String.format("%s-%s-%s", this.getFormat(), this.getLayout(), this.getInterpretation()));
            try {
                this.client.ping();
            }
            catch (Exception e) {
                throw new IndexClientException("oops something went wrong", (Throwable)e);
            }
        }
        return this.client;
    }

    public void setClient(CloudSolrClient client) {
        this.client = client;
    }

    public LookupResponse lookup(String query, List<String> filterQuery, int from, int to) throws IndexClientException {
        log.debug((Object)("lookup request for the index collection for query:" + query));
        MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
        SolrIndexQuery translatedQuery = (SolrIndexQuery)this.solrIndexQueryFactory.getIndexQuery(QueryLanguage.CQL, query, this, mdRef);
        translatedQuery.setQueryOffset(from);
        translatedQuery.setQueryLimit(to - from + 1);
        if (filterQuery != null) {
            for (String fq : filterQuery) {
                translatedQuery.addFilterQuery(new String[]{fq});
            }
        }
        try {
            SolrIndexQueryResponse response = new SolrIndexQueryResponse(this.client.query((SolrParams)translatedQuery));
            QueryResponseParser responseParser = this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)response, mdRef);
            return new LookupResponse(responseParser);
        }
        catch (IOException | SolrServerException e) {
            throw new IndexClientException("Error on executing a query " + query, e);
        }
    }

    public CqlValueTransformerMap getCqlValueTransformerMap(MetadataReference mdRef) throws IndexClientException {
        try {
            return this.tMapFactory.getIt(this.readFieldNamesAndTypes(mdRef.toString()));
        }
        catch (Exception e) {
            throw new IndexClientException((Throwable)e);
        }
    }

    public IndexQueryFactory getIndexQueryFactory() {
        return this.solrIndexQueryFactory;
    }

    public void stop() throws IndexClientException {
        try {
            log.debug((Object)("shutdown client: " + (String)this.serviceProperties.get(ZK_ADDRESS)));
            this.client.close();
        }
        catch (Throwable e) {
            throw new IndexClientException(e);
        }
    }

    private List<BrowseEntry> convertBrowseEntry(List<String> browseFields, List<BrowsingRow> results, BiMap<String, String> aliases) {
        HashMap<String, BrowseEntry> mapResult = new HashMap<String, BrowseEntry>();
        for (BrowsingRow row : results) {
            for (GroupResult groupResult : row.getGroupResult()) {
                ArrayList<BrowseValueEntry> valuesEntry;
                BrowseEntry entry;
                String name = groupResult.getName();
                if (mapResult.containsKey(name)) {
                    entry = (BrowseEntry)mapResult.get(name);
                    valuesEntry = entry.getValues();
                    if (valuesEntry == null) {
                        valuesEntry = new ArrayList<BrowseValueEntry>();
                        entry.setValues(valuesEntry);
                    }
                } else {
                    entry = new BrowseEntry();
                    entry.setField(name);
                    entry.setLabel(name);
                    valuesEntry = new ArrayList();
                    entry.setValues(valuesEntry);
                    mapResult.put(name, entry);
                }
                String value = groupResult.getValue();
                int count = groupResult.getCount();
                BrowseValueEntry entryValue = new BrowseValueEntry(value, count);
                valuesEntry.add(entryValue);
            }
        }
        ArrayList<BrowseEntry> out = new ArrayList<BrowseEntry>();
        for (String b : browseFields) {
            String inverse = null;
            if (aliases != null) {
                String string = inverse = aliases.get((Object)b) != null ? (String)aliases.get((Object)b) : (String)aliases.inverse().get((Object)b);
            }
            if (mapResult.containsKey(b)) {
                out.add((BrowseEntry)mapResult.get(b));
                continue;
            }
            if (!mapResult.containsKey(inverse)) continue;
            BrowseEntry data = (BrowseEntry)mapResult.get(inverse);
            data.setField(b);
            out.add(data);
        }
        return out;
    }

    private Map<String, Any.ValueType> readFieldNamesAndTypes(String coreName) throws SolrServerException, IOException, IndexClientException {
        LukeRequest request = new LukeRequest();
        request.setShowSchema(true);
        request.setNumTerms(0);
        LukeResponse response = (LukeResponse)request.process(this.getClient());
        Map fieldInfos = response.getFieldInfo();
        Map fieldTypeInfos = response.getFieldTypeInfo();
        HashMap result = Maps.newHashMap();
        for (LukeResponse.FieldInfo fieldInfo : fieldInfos.values()) {
            LukeResponse.FieldTypeInfo fieldTypeInfo = (LukeResponse.FieldTypeInfo)fieldTypeInfos.get(fieldInfo.getType());
            String fieldName = fieldTypeInfo.getName().toLowerCase();
            Any.ValueType fieldType = this.resolveSolrTypeClassName(fieldName);
            result.put(fieldInfo.getName(), fieldType);
        }
        return result;
    }

    private Any.ValueType resolveSolrTypeClassName(String solrTypeName) {
        if (solrTypeName.contains("LongField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("IntField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("short")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("float")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeName.contains("double")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeName.contains("date")) {
            return Any.ValueType.DATETIME;
        }
        return Any.ValueType.STRING;
    }
}

