/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.index.solr.feed.ResultTransformer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.solr.common.SolrInputDocument;

public class StreamingInputDocumentFactory
extends InputDocumentFactory {
    protected static final String DEFAULTDNETRESULT = "dnetResult";
    protected static final String TARGETFIELDS = "targetFields";
    protected static final String INDEX_RECORD_ID_ELEMENT = "indexRecordIdentifier";
    protected static final String ROOT_ELEMENT = "indexRecord";
    protected static final int MAX_FIELD_LENGTH = 25000;
    protected ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    protected ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    protected ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };

    @Override
    public SolrInputDocument parseDocument(String version, String inputDocument, String dsId, String resultName) throws XMLStreamException {
        return this.parseDocument(version, inputDocument, dsId, resultName, null);
    }

    @Override
    public SolrInputDocument parseDocument(String version, String inputDocument, String dsId, String resultName, ResultTransformer resultTransformer) {
        StringWriter results = new StringWriter();
        LinkedList nsList = Lists.newLinkedList();
        try {
            XMLEventReader parser = this.inputFactory.get().createXMLEventReader(new StringReader(inputDocument));
            SolrInputDocument indexDocument = new SolrInputDocument(new HashMap());
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event == null || !event.isStartElement()) continue;
                String localName = event.asStartElement().getName().getLocalPart();
                if (ROOT_ELEMENT.equals(localName)) {
                    nsList.addAll(this.getNamespaces(event));
                    continue;
                }
                if (INDEX_RECORD_ID_ELEMENT.equals(localName)) {
                    XMLEvent text = parser.nextEvent();
                    String recordId = this.getText(text);
                    indexDocument.addField("__indexrecordidentifier", (Object)recordId);
                    continue;
                }
                if (TARGETFIELDS.equals(localName)) {
                    this.parseTargetFields(indexDocument, parser);
                    continue;
                }
                if (!resultName.equals(localName) || resultTransformer != null && ResultTransformer.Mode.empty.equals((Object)resultTransformer.getMode())) continue;
                this.copyResult(indexDocument, results, parser, nsList, resultName, resultTransformer);
            }
            if (version != null) {
                indexDocument.addField("__dsversion", (Object)version);
            }
            if (dsId != null) {
                indexDocument.addField("__dsid", (Object)dsId);
            }
            if (!indexDocument.containsKey((Object)"__indexrecordidentifier")) {
                indexDocument.clear();
                System.err.println("missing indexrecord id:\n" + inputDocument);
            }
            return indexDocument;
        }
        catch (XMLStreamException e) {
            return new SolrInputDocument();
        }
    }

    private List<Namespace> getNamespaces(XMLEvent event) {
        LinkedList res = Lists.newLinkedList();
        Iterator<Namespace> nsIter = event.asStartElement().getNamespaces();
        while (nsIter.hasNext()) {
            Namespace ns = nsIter.next();
            res.add(ns);
        }
        return res;
    }

    protected void parseTargetFields(SolrInputDocument indexDocument, XMLEventReader parser) throws XMLStreamException {
        XMLEvent targetEvent;
        boolean hasFields = false;
        while (!(!parser.hasNext() || (targetEvent = parser.nextEvent()).isEndElement() && targetEvent.asEndElement().getName().getLocalPart().equals(TARGETFIELDS))) {
            if (!targetEvent.isStartElement()) continue;
            String fieldName = targetEvent.asStartElement().getName().getLocalPart();
            XMLEvent text = parser.nextEvent();
            String data = this.getText(text);
            this.addField(indexDocument, fieldName, data);
            hasFields = true;
        }
        if (!hasFields) {
            indexDocument.clear();
        }
    }

    protected void copyResult(SolrInputDocument indexDocument, StringWriter results, XMLEventReader parser, List<Namespace> nsList, String dnetResult, ResultTransformer resultTransformer) throws XMLStreamException {
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(results);
        for (Namespace ns : nsList) {
            this.eventFactory.get().createNamespace(ns.getPrefix(), ns.getNamespaceURI());
        }
        StartElement newRecord = this.eventFactory.get().createStartElement("", null, "result", null, nsList.iterator());
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent resultEvent = parser.nextEvent();
            if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals(dnetResult)) {
                writer.add(this.eventFactory.get().createEndElement("", null, "result"));
                break;
            }
            writer.add(resultEvent);
        }
        writer.close();
        if (resultTransformer != null) {
            indexDocument.addField("__result", resultTransformer.apply(results.toString()));
        } else {
            indexDocument.addField("__result", (Object)results.toString());
        }
    }

    private final void addField(SolrInputDocument indexDocument, String field, String value) {
        String cleaned = value.trim();
        if (!cleaned.isEmpty()) {
            indexDocument.addField(field.toLowerCase(), (Object)cleaned);
        }
    }

    protected final String getText(XMLEvent text) {
        if (text.isEndElement()) {
            return "";
        }
        String data = text.asCharacters().getData();
        if (data != null && data.length() > 25000) {
            return data.substring(0, 25000);
        }
        return data;
    }
}

