/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class OAVersionEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust, Set<String> untrustedOaDsList) throws IOException, InterruptedException, DocumentException {
        new OAVersionEventFactory().processOAVersion(context, current, other, trust, untrustedOaDsList);
    }

    private void processOAVersion(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust, Set<String> untrustedOaDsList) throws IOException, InterruptedException, DocumentException {
        String otherDsId = StringUtils.substringAfter((String)OafHbaseUtils.getKey(other.getEntity().getCollectedfromList()), (String)"|");
        if (!untrustedOaDsList.contains(otherDsId) && this.hasAccess(other, "OPEN", false)) {
            this.doProcessOAVersion(context, current, other, Topic.ENRICH_MORE_OA_VERSION, trust);
            if (!this.hasAccess(current, "OPEN", true)) {
                this.doProcessOAVersion(context, current, other, Topic.ENRICH_MISSING_OA_VERSION, trust);
            }
        }
    }

    private void doProcessOAVersion(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        Iterable i = Iterables.filter((Iterable)other.getEntity().getResult().getInstanceList(), (Predicate)new Predicate<ResultProtos.Result.Instance>(){

            public boolean apply(ResultProtos.Result.Instance i) {
                return "OPEN".equalsIgnoreCase(i.getLicence().getClassid());
            }
        });
        prototype.getEntityBuilder().getResultBuilder().addAllInstance(i);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichOa(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), Lists.newArrayList((Iterable)i));
        EventMessage event = EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust);
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }

    private boolean hasAccess(OafProtos.Oaf oaf, final String access, boolean strict) {
        Predicate<ResultProtos.Result.Instance> p = new Predicate<ResultProtos.Result.Instance>(){

            public boolean apply(ResultProtos.Result.Instance i) {
                return access.equalsIgnoreCase(i.getLicence().getClassid());
            }
        };
        List i = oaf.getEntity().getResult().getInstanceList();
        return strict ? Iterables.all((Iterable)i, (Predicate)p) : Iterables.any((Iterable)i, (Predicate)p);
    }
}

