/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class SubjectEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        new SubjectEventFactory().processSubjectPair(context, current, other, Float.valueOf(trust));
    }

    public static void process(Reducer.Context context, OafProtos.Oaf current) throws IOException, InterruptedException, DocumentException {
        new SubjectEventFactory().processSubjectSingle(context, current);
    }

    private void processSubjectSingle(Reducer.Context context, OafProtos.Oaf current) throws InterruptedException, DocumentException, IOException {
        ResultProtos.Result.Metadata mCurrent = current.getEntity().getResult().getMetadata();
        if (mCurrent.getSubjectList().isEmpty()) {
            for (FieldTypeProtos.StructuredProperty subject : mCurrent.getSubjectList()) {
                if (!subject.hasDataInfo() || !subject.getDataInfo().getInferred()) continue;
                this.doProcessSubject(context, current, null, subject, this.getSubjectTopic(subject, true), Float.valueOf(subject.getDataInfo().getTrust()));
            }
        }
    }

    private void processSubjectPair(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException {
        ResultProtos.Result.Metadata mCurrent = current.getEntity().getResult().getMetadata();
        ResultProtos.Result.Metadata mOther = other.getEntity().getResult().getMetadata();
        if (mCurrent.getSubjectList().isEmpty()) {
            for (FieldTypeProtos.StructuredProperty subjectOther : mOther.getSubjectList()) {
                this.doProcessSubject(context, current, other, subjectOther, this.getSubjectTopic(subjectOther, true), trust);
            }
        }
        if (other != null) {
            for (FieldTypeProtos.StructuredProperty subjectOther : mOther.getSubjectList()) {
                if (this.hasSubjectValue(current, subjectOther.getQualifier().getClassid(), subjectOther.getValue())) continue;
                this.doProcessSubject(context, current, other, subjectOther, this.getSubjectTopic(subjectOther, false), trust);
            }
        }
    }

    private void doProcessSubject(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, FieldTypeProtos.StructuredProperty subjectOther, Topic topic, Float trust) throws IOException, InterruptedException {
        if (topic == null) {
            context.getCounter("event", "SUBJECT not mapped").increment(1L);
            return;
        }
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().addSubject(subjectOther);
        OafProtos.Oaf oaf = prototype.build();
        OafProtos.OafEntity eventEntity = other != null ? other.getEntity() : current.getEntity();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichSubject(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), eventEntity, trust.floatValue()), Lists.newArrayList((Object[])new FieldTypeProtos.StructuredProperty[]{subjectOther}));
        EventMessage event = EventFactory.asEvent(oaf.getEntity(), topic, payload, eventEntity, trust.floatValue());
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }

    private Topic getSubjectTopic(FieldTypeProtos.StructuredProperty subject, boolean missingOrMore) {
        switch (subject.getQualifier().getClassid()) {
            case "mesheuropmc": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_MESHEUROPMC : Topic.ENRICH_MORE_SUBJECT_MESHEUROPMC;
            }
            case "arxiv": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_ARXIV : Topic.ENRICH_MORE_SUBJECT_ARXIV;
            }
            case "jel": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_JEL : Topic.ENRICH_MORE_SUBJECT_JEL;
            }
            case "ddc": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_DDC : Topic.ENRICH_MORE_SUBJECT_DDC;
            }
            case "acm": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_ACM : Topic.ENRICH_MORE_SUBJECT_ACM;
            }
            case "rvk": {
                return missingOrMore ? Topic.ENRICH_MISSING_SUBJECT_RVK : Topic.ENRICH_MORE_SUBJECT_RVK;
            }
        }
        return null;
    }

    private boolean hasSubjectValue(OafProtos.Oaf oaf, final String classId, final String value) {
        return Iterables.any((Iterable)oaf.getEntity().getResult().getMetadata().getSubjectList(), (Predicate)new Predicate<FieldTypeProtos.StructuredProperty>(){

            public boolean apply(FieldTypeProtos.StructuredProperty subject) {
                return subject.getValue().equalsIgnoreCase(value) & subject.getQualifier().getClassid().endsWith(classId);
            }
        });
    }
}

