/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.ExternalReference;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.Pid;
import eu.dnetlib.broker.objects.Project;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class ProtoMapping {
    protected static List<Instance> mapInstances(List<ResultProtos.Result.Instance> in) {
        return Lists.newArrayList((Iterable)Iterables.transform(in, (Function)new Function<ResultProtos.Result.Instance, Instance>(){

            public Instance apply(ResultProtos.Result.Instance i) {
                return new Instance().setHostedby(OafHbaseUtils.getValue(i.getHostedby())).setInstancetype(OafHbaseUtils.getValue(i.getInstancetype())).setLicense(OafHbaseUtils.getKey(i.getLicence())).setUrl((String)Iterables.getFirst((Iterable)i.getUrlList(), (Object)""));
            }
        }));
    }

    protected static List<Pid> mapPids(List<FieldTypeProtos.StructuredProperty> sp) {
        return Lists.newArrayList((Iterable)Iterables.transform(sp, (Function)new Function<FieldTypeProtos.StructuredProperty, Pid>(){

            public Pid apply(FieldTypeProtos.StructuredProperty sp) {
                return new Pid().setType(sp.getQualifier().getClassid()).setValue(sp.getValue());
            }
        }));
    }

    protected static List<ExternalReference> mapExternalRefs(List<ResultProtos.Result.ExternalReference> ext) {
        return Lists.newArrayList((Iterable)Iterables.transform(ext, (Function)new Function<ResultProtos.Result.ExternalReference, ExternalReference>(){

            public ExternalReference apply(ResultProtos.Result.ExternalReference e) {
                return new ExternalReference().setUrl(e.getUrl()).setType(OafHbaseUtils.getKey(e.getQualifier())).setRefidentifier(e.getRefidentifier()).setSitename(e.getSitename());
            }
        }));
    }

    protected static final List<Project> mapRelatedProjects(OafProtos.OafEntity oaf) {
        Function<OafProtos.OafRel, Project> toProject = new Function<OafProtos.OafRel, Project>(){

            public Project apply(OafProtos.OafRel rel) {
                Project project = new Project();
                switch (rel.getRelType()) {
                    case resultProject: {
                        ProjectProtos.Project.Metadata mp = rel.getCachedTarget().getProject().getMetadata();
                        String ftree = OafHbaseUtils.getValue(mp.getFundingtreeList());
                        project.setCode(OafHbaseUtils.getValue(mp.getCode()));
                        project.setAcronym(OafHbaseUtils.getValue(mp.getAcronym()));
                        project.setTitle(OafHbaseUtils.getValue(mp.getTitle()));
                        if (!StringUtils.isNotBlank((String)ftree)) break;
                        try {
                            Document fdoc = new SAXReader().read((Reader)new StringReader(ftree));
                            project.setFunder(fdoc.valueOf("/funder/shortname"));
                            project.setJurisdiction(fdoc.valueOf("/funder/jurisdiction"));
                            project.setFundingProgram(fdoc.valueOf("//funding_level_0/name"));
                            break;
                        }
                        catch (DocumentException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                return project;
            }
        };
        if (oaf.getCachedRelList() != null) {
            return Lists.transform((List)oaf.getCachedRelList(), (Function)toProject);
        }
        return Lists.newArrayList();
    }
}

