/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class EnrichmentMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private ImmutableBytesWritable outValue;
    private ImmutableBytesWritable outKey;

    protected void setup(Mapper.Context context) {
        this.outKey = new ImmutableBytesWritable();
        this.outValue = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap result = value.getFamilyMap(Bytes.toBytes((String)TypeProtos.Type.result.name()));
        if (MapUtils.isEmpty((Map)result)) {
            context.getCounter(TypeProtos.Type.result.name(), "empty family map").increment(1L);
            return;
        }
        OafProtos.Oaf body = UpdateMerger.mergeBodyUpdates(context, result);
        if (body == null) {
            context.getCounter(TypeProtos.Type.result.name(), "body null").increment(1L);
            return;
        }
        String mergedInCF = DedupUtils.getDedupCF_mergedIn(TypeProtos.Type.result);
        NavigableMap mergedIn = value.getFamilyMap(Bytes.toBytes((String)mergedInCF));
        String outKey = this.getEmitKey(context, key, mergedIn);
        this.emit(context, outKey, body);
    }

    private String getEmitKey(Mapper.Context context, ImmutableBytesWritable key, Map<byte[], byte[]> mergedIn) {
        if (MapUtils.isNotEmpty(mergedIn)) {
            context.getCounter(TypeProtos.Type.result.name(), DedupProtos.Dedup.RelName.isMergedIn.name()).increment(1L);
            return this.getRootId(mergedIn, context);
        }
        return new String(key.copyBytes());
    }

    private void emit(Mapper.Context context, String key, OafProtos.Oaf body) throws IOException, InterruptedException {
        this.outKey.set(Bytes.toBytes((String)key));
        this.outValue.set(body.toByteArray());
        context.write((Object)this.outKey, (Object)this.outValue);
    }

    private String getRootId(Map<byte[], byte[]> mergedIn, Mapper.Context context) {
        HashSet ids = Sets.newHashSet((Iterable)Iterables.transform(mergedIn.keySet(), (Function)new Function<byte[], String>(){

            public String apply(byte[] input) {
                return new String(input);
            }
        }));
        try {
            return (String)Iterables.getOnlyElement((Iterable)ids);
        }
        catch (IllegalArgumentException e) {
            System.err.println(ids);
            throw e;
        }
    }
}

