/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class PrepareEnrichementMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = this.getEntityType(key);
        byte[] body = value.getValue(Bytes.toBytes((String)type.toString()), Bytes.toBytes((String)"body"));
        if (body == null) {
            context.getCounter("body", "empty oaf").increment(1L);
            return;
        }
        switch (type) {
            case project: {
                for (ImmutableBytesWritable resultId : this.listRelatedIds(value, "resultProject_outcome_produces")) {
                    context.write((Object)resultId, (Object)new ImmutableBytesWritable(body));
                }
                break;
            }
            case result: {
                NavigableMap mergedIn = value.getFamilyMap(DedupUtils.getDedupCF_mergedInBytes(TypeProtos.Type.result));
                if (MapUtils.isNotEmpty((Map)mergedIn)) {
                    context.write((Object)this.getRootId(mergedIn), (Object)new ImmutableBytesWritable(body));
                    break;
                }
                if (DedupUtils.isRoot(key)) break;
                OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)OafDecoder.decode((byte[])body).getOaf());
                for (String relName : Arrays.asList("resultProject_outcome_isProducedBy")) {
                    this.handleRels(oafBuilder, value, body, relName);
                }
                context.write((Object)new ImmutableBytesWritable(key.copyBytes()), (Object)new ImmutableBytesWritable(oafBuilder.build().toByteArray()));
                break;
            }
            default: {
                context.getCounter("invalid entity", type.toString()).increment(1L);
            }
        }
    }

    public void handleRels(OafProtos.Oaf.Builder oafBuilder, Result value, byte[] body, String relName) throws IOException, InterruptedException {
        Iterable<OafProtos.Oaf> rels = this.listRelations(value, relName);
        if (!Iterables.isEmpty(rels)) {
            for (OafProtos.Oaf oaf : rels) {
                String provenance = oaf.getDataInfo().getProvenanceaction().getClassid();
                OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder((OafProtos.OafRel)oaf.getRel());
                relBuilder.addCollectedfrom(FieldTypeProtos.KeyValue.newBuilder().setKey(provenance));
                oafBuilder.getEntityBuilder().addCachedRel(relBuilder.build());
            }
        }
    }

    private Iterable<OafProtos.Oaf> listRelations(Result value, String relType) {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)relType));
        if (map != null) {
            return Iterables.transform(map.keySet(), (Function)new Function<byte[], OafProtos.Oaf>(){

                public OafProtos.Oaf apply(byte[] input) {
                    try {
                        return OafProtos.Oaf.parseFrom((byte[])input);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return Lists.newArrayList();
    }

    private Iterable<ImmutableBytesWritable> listRelatedIds(Result value, String relType) {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)relType));
        if (map != null) {
            return Iterables.transform(map.keySet(), (Function)new Function<byte[], ImmutableBytesWritable>(){

                public ImmutableBytesWritable apply(byte[] input) {
                    return new ImmutableBytesWritable(input);
                }
            });
        }
        return Lists.newArrayList();
    }

    private TypeProtos.Type getEntityType(ImmutableBytesWritable key) {
        return OafRowKeyDecoder.decode((byte[])key.copyBytes()).getType();
    }

    private ImmutableBytesWritable getRootId(Map<byte[], byte[]> mergedIn) {
        Iterable ids = Iterables.transform(mergedIn.keySet(), (Function)new Function<byte[], ImmutableBytesWritable>(){

            public ImmutableBytesWritable apply(byte[] input) {
                return new ImmutableBytesWritable(input);
            }
        });
        try {
            return (ImmutableBytesWritable)Iterables.getOnlyElement((Iterable)ids);
        }
        catch (IllegalArgumentException e) {
            System.err.println(ids);
            throw e;
        }
    }
}

