package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getKey;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getValue;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.listValues;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Maps;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValue;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValueType;
import eu.dnetlib.data.proto.OafProtos.OafEntity;

/**
 * Created by claudio on 20/07/16.
 */
public class EventFactory {

	private final static String PRODUCER_ID = "OpenAIRE";

	public static EventMessage asEvent(final OafEntity oaf, final Topic topic, final OpenAireEventPayload payload, final OafEntity source, final float trust) {
		return asEvent(oaf, topic, payload, getKey(source.getCollectedfromList()), getValue(source.getCollectedfromList()), trust,
				listValues(source.getOriginalIdList()));
	}

	public static EventMessage asEvent(final OafEntity oaf,
			final Topic topic,
			final OpenAireEventPayload payload,
			final String sourceDatasourceId,
			final String sourceDatasourceName,
			final float trust) {
		return asEvent(oaf, topic, payload, sourceDatasourceId, sourceDatasourceName, trust, null);
	}

	public static EventMessage asEvent(final OafEntity oaf,
			final Topic topic,
			final OpenAireEventPayload payload,
			final String sourceDatasourceId,
			final String sourceDatasourceName,
			final float trust,
			final List<String> sourceOriginalIds) {
		final Map<String, MapValue> map = Maps.newHashMap();

		// TARGET INFO
		final String targetDatasourceId = getKey(oaf.getCollectedfromList());
		if (StringUtils.isNotBlank(targetDatasourceId)) {
			map.put("target_datasource_id", new MapValue(MapValueType.STRING, targetDatasourceId));
		}

		final String targetDatasourceName = getValue(oaf.getCollectedfromList());
		if (StringUtils.isNotBlank(targetDatasourceName)) {
			map.put("target_datasource_name", new MapValue(MapValueType.STRING, targetDatasourceName));
		}

		final String title = getValue(oaf.getResult().getMetadata().getTitleList());
		if (StringUtils.isNotBlank(title)) {
			map.put("target_publication_title", new MapValue(MapValueType.STRING, title));
		}

		final String date = oaf.getResult().getMetadata().getDateofacceptance().getValue();
		if (StringUtils.isNotBlank(date)) {
			map.put("target_dateofacceptance", new MapValue(MapValueType.DATE, date));
		}

		final List<String> subjects = listValues(oaf.getResult().getMetadata().getSubjectList());
		if ((subjects != null) && !subjects.isEmpty()) {
			map.put("target_publication_subject_list", new MapValue(MapValueType.LIST_STRING, subjects));
		}

		final List<String> authors = listValues(oaf.getResult().getAuthorList());
		if ((authors != null) && !authors.isEmpty()) {
			map.put("target_publication_author_list", new MapValue(MapValueType.LIST_STRING, authors));
		}

		map.put("target_publication_id", new MapValue(MapValueType.STRING, getValue(oaf.getOriginalIdList())));
		map.put("trust", new MapValue(MapValueType.FLOAT, trust));

		// PROVENANCE INFO
		if (StringUtils.isNotBlank(sourceDatasourceName)) {
			map.put("provenance_datasource_name", new MapValue(MapValueType.STRING, sourceDatasourceName));
		}

		if (StringUtils.isNotBlank(sourceDatasourceId)) {
			map.put("provenance_datasource_id", new MapValue(MapValueType.STRING, sourceDatasourceId));
		}

		if ((sourceOriginalIds != null) && !sourceOriginalIds.isEmpty()) {
			map.put("provenance_publication_id_list", new MapValue(MapValueType.LIST_STRING, sourceOriginalIds));
		}

		// final OpenAireEventPayload p = new OpenAireEventPayload(oaf.getEntity().getId());

		return new EventMessage(PRODUCER_ID, topic, payload.toJSON(), EventMessage.TTH_INFINITE, map);
	}

}
