package eu.dnetlib.data.mapreduce.hbase.broker;

import static eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory.asEvent;

import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer.Context;
import org.dom4j.DocumentException;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.Oaf;

/**
 * Created by claudio on 26/07/16.
 */
public class PIDEventFactory {

	protected Text tKey = new Text("");

	public static void process(final Context context, final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {
		new PIDEventFactory().processPID(context, current, other, trust);
	}

	public void processPID(final Context context, final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {
		// PIDS
		if (current.getEntity().getPidList().isEmpty()) {
			for (final StructuredProperty pidOther : other.getEntity().getPidList()) {
				doProcessPID(context, current, other, pidOther, Topic.ENRICH_MISSING_PID, trust);
			}
		}

		for (final StructuredProperty pidOther : other.getEntity().getPidList()) {
			if (!hasPidValue(current, pidOther.getValue())) {
				doProcessPID(context, current, other, pidOther, Topic.ENRICH_MORE_PID, trust);
			}
		}
	}

	private void doProcessPID(final Context context,
			final Oaf current,
			final Oaf other,
			final StructuredProperty pidOther,
			final Topic topic,
			final float trust) throws IOException, InterruptedException, DocumentException {
		final Oaf.Builder prototype = Oaf.newBuilder(current);
		prototype.getEntityBuilder().addPid(pidOther);
		final Oaf oaf = prototype.build();

		final OpenAireEventPayload payload =
				HighlightFactory.highlightEnrichPid(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust),
						Lists.newArrayList(pidOther));
		final EventMessage event = asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust);

		context.write(tKey, new Text(event.toString()));
		context.getCounter("event", topic.getValue()).increment(1);
	}

	private boolean hasPidValue(final Oaf oaf, final String value) {
		return Iterables.any(oaf.getEntity().getPidList(), new Predicate<StructuredProperty>() {

			@Override
			public boolean apply(final StructuredProperty pid) {
				return pid.getValue().equalsIgnoreCase(value);
			}
		});
	}
}
