package eu.dnetlib.data.mapreduce.hbase.broker;

import static eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory.asEvent;

import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer.Context;
import org.dom4j.DocumentException;

import com.google.common.collect.Iterables;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;

@SuppressWarnings("rawtypes")
public class ProjectEventFactory {

	protected Text tKey = new Text("");

	public static void process(final Context context, final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {
		new ProjectEventFactory().processProject(context, current, other, trust);
	}

	private void processProject(final Context context, final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {

		if (other == null) {
			for (final OafRel rel : current.getEntity().getCachedRelList()) {
				doProcessProject(context, current, rel.getCachedTarget(), getProvenance(rel), Topic.ENRICH_MISSING_PROJECT, trust);
			}
		} else {
			for (final OafRel currentRel : current.getEntity().getCachedRelList()) {
				for (final OafRel otherRel : other.getEntity().getCachedRelList()) {
					if (!currentRel.getTarget().equals(otherRel.getTarget())) {
						doProcessProject(context, current, other.getEntity(), getProvenance(otherRel), Topic.ENRICH_MISSING_PROJECT, trust);
					}

				}
			}
		}
	}

	private String getProvenance(final OafRel rel) {
		return Iterables.getOnlyElement(rel.getCollectedfromList()).getKey();
	}

	private void doProcessProject(final Context context,
			final Oaf current,
			final OafEntity project,
			final String provenance,
			final Topic topic,
			final float trust)
			throws IOException, InterruptedException, DocumentException {

		// final OafEntity oaf, final Topic topic, final OpenAireEventPayload payload, final OafEntity source, final float trust

		final OpenAireEventPayload payload = OpenAireEventPayloadFactory.fromOAF(current.getEntity(), current.getEntity(), trust);
		final EventMessage event = asEvent(current.getEntity(), topic, payload, current.getEntity(), trust);

		event.setPayload(HighlightFactory.highlightEnrichProject(payload, project, provenance).toJSON());

		context.write(tKey, new Text(event.toString()));
		context.getCounter("event", topic.getValue()).increment(1);
	}

}
