package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import eu.dnetlib.data.mapreduce.OptionalConfig;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.apache.commons.collections.CollectionUtils;

public class IndexConfig extends OptionalConfig {

	public static IndexConfig load(final String s) {
		return new IndexConfig(ConfigFactory.parseReader(new StringReader(s)));
	}

	public IndexConfig(final Config config) {
		super(config);
	}

	@SuppressWarnings("unchecked")
	public EntityConfigTable getConfigMap() {
		final ConfigObject modelMap = getConfig().getObject("index.conf");
		final Map<String, EntityConfig> map = Maps.transformValues(modelMap, new Function<ConfigValue, EntityConfig>() {

			@Override
			public EntityConfig apply(final ConfigValue value) {

				final HashMap<RelDescriptor, LinkDescriptor> links = Maps.newHashMap();
				for (final Object o : (List<?>) ((Map<String, ?>) value.unwrapped()).get("links")) {
					final Map<String, ?> map = (Map<String, ?>) o;

					final RelDescriptor relDescriptor = new RelDescriptor((String) map.get("relType"));
					final Set<String> fields = Sets.newHashSet((List<String>) map.get("fields"));
					final Type target = Type.valueOf((String) map.get("targetEntity"));
					final Boolean isChild = ((String) map.get("expandAs")).equals("child");
					final Boolean symmetric = (Boolean) map.get("symmetric");

					final LinkDescriptor ld = new LinkDescriptor(relDescriptor, target, isChild, symmetric, fields);

					if (map.containsKey("max")) {
						ld.setMax((Integer) map.get("max"));
					}

					links.put(relDescriptor, ld);
				}
				final List<String> includeFields = (List<String>) ((Map<String, ?>) value.unwrapped()).get("includeFields");
				final List<String> excludeFields = (List<String>) ((Map<String, ?>) value.unwrapped()).get("excludeFields");
				if(CollectionUtils.isNotEmpty(includeFields) & CollectionUtils.isNotEmpty(excludeFields)){
					throw new RuntimeException("Cannot create the index configuration: includeFields and excludeFields are both not null");
				}
				return new EntityConfig((Boolean) ((Map<String, ?>) value.unwrapped()).get("dups"), links, includeFields, excludeFields);
			}
		});

		final EntityConfigTable res = new EntityConfigTable();
		for (final String key : map.keySet()) {
			res.put(Type.valueOf(key), map.get(key));
		}
		return res;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

}
