/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.ProtoMapping;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.util.List;

public class HighlightFactory
extends ProtoMapping {
    public static OpenAireEventPayload highlightEnrichOa(OpenAireEventPayload p, List<ResultProtos.Result.Instance> instances) {
        p.getHighlight().setInstances(HighlightFactory.mapInstances(instances));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichPid(OpenAireEventPayload p, List<FieldTypeProtos.StructuredProperty> pids) {
        p.getHighlight().setPids(HighlightFactory.mapPids(pids));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichPublicationDate(OpenAireEventPayload p, FieldTypeProtos.StringField date) {
        p.getHighlight().setPublicationdate(OafHbaseUtils.getValue(date));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichAbstract(OpenAireEventPayload p, List<FieldTypeProtos.StringField> descriptionList) {
        p.getHighlight().setAbstracts(OafHbaseUtils.listValues(descriptionList));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichSubject(OpenAireEventPayload p, List<FieldTypeProtos.StructuredProperty> subjects) {
        p.getHighlight().setSubjects(OafHbaseUtils.listValues(subjects));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichProject(OpenAireEventPayload p, OafProtos.OafEntity projectEntity, String provenance) {
        ProjectProtos.Project project = projectEntity.getProject();
        ProjectProtos.Project.Metadata projectMetadata = project.getMetadata();
        FieldTypeProtos.StringField acro = projectMetadata.getAcronym();
        FieldTypeProtos.StringField title = projectMetadata.getTitle();
        FieldTypeProtos.StringField code = projectMetadata.getCode();
        List fundingtree = projectMetadata.getFundingtreeList();
        String fundingTrees = "<fundings>" + Joiner.on((String)" ").join(Iterables.transform((Iterable)fundingtree, (Function)new Function<FieldTypeProtos.StringField, String>(){

            public String apply(FieldTypeProtos.StringField v) {
                return v.getValue();
            }
        })) + "</fundings>";
        return p;
    }

    public static OpenAireEventPayload highlightEnrichDataset(OpenAireEventPayload p) {
        return p;
    }

    public static OpenAireEventPayload highlightEnrichAuthorPid(OpenAireEventPayload p) {
        return p;
    }
}

