package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getKey;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getValue;

import java.io.StringReader;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import eu.dnetlib.broker.objects.ExternalReference;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.Pid;
import eu.dnetlib.broker.objects.Project;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.ResultProtos.Result;

/**
 * Created by claudio on 22/07/16.
 */
public abstract class ProtoMapping {

	protected static List<Instance> mapInstances(final List<Result.Instance> in) {
		return Lists.newArrayList(Iterables.transform(in, new Function<Result.Instance, Instance>() {

			@Override
			public Instance apply(final Result.Instance i) {
				return new Instance()
						.setHostedby(getValue(i.getHostedby()))
						.setInstancetype(getValue(i.getInstancetype()))
						.setLicense(getKey(i.getLicence()))
						.setUrl(Iterables.getFirst(i.getUrlList(), ""));
			}
		}));
	}

	protected static List<Pid> mapPids(final List<StructuredProperty> sp) {
		return Lists.newArrayList(Iterables.transform(sp, new Function<StructuredProperty, Pid>() {

			@Override
			public Pid apply(final StructuredProperty sp) {
				return new Pid().setType(sp.getQualifier().getClassid()).setValue(sp.getValue());
			}
		}));
	}

	protected static List<ExternalReference> mapExternalRefs(final List<Result.ExternalReference> ext) {
		return Lists.newArrayList(Iterables.transform(ext, new Function<Result.ExternalReference, ExternalReference>() {

			@Override
			public ExternalReference apply(final Result.ExternalReference e) {
				return new ExternalReference()
						.setUrl(e.getUrl())
						.setType(getKey(e.getQualifier()))
						.setRefidentifier(e.getRefidentifier())
						.setSitename(e.getSitename());
			}
		}));
	}

	protected static final List<Project> mapRelatedProjects(final OafEntity oaf) {

		// TODO: per ogni REL di tipo progetto creare un oggetto Project (sfruttando gli elementi nella seconda lista)
		final Function<OafRel, Project> toProject = new Function<OafRel, Project>() {

			@Override
			public Project apply(final OafRel rel) {
				final Project project = new Project();
				switch (rel.getRelType()) {
				case resultProject:
					final eu.dnetlib.data.proto.ProjectProtos.Project.Metadata mp = rel.getCachedTarget().getProject().getMetadata();
					final String ftree = getValue(mp.getFundingtreeList());

					project.setCode(getValue(mp.getCode()));
					project.setAcronym(getValue(mp.getAcronym()));
					project.setTitle(getValue(mp.getTitle()));

					if (StringUtils.isNotBlank(ftree)) {
						try {
							final Document fdoc = new SAXReader().read(new StringReader(ftree));
							project.setFunder(fdoc.valueOf("/funder/shortname"));
							project.setJurisdiction(fdoc.valueOf("/funder/jurisdiction"));
							project.setFundingProgram(fdoc.valueOf("//funding_level_0/name"));
						} catch (final DocumentException e) {
							throw new RuntimeException(e);
						}
					}
					break;
				default:
					break;
				}
				return project;
			}
		};
		if (oaf.getCachedRelList() != null) { return Lists.transform(oaf.getCachedRelList(), toProject); }
		return Lists.newArrayList();

	}

}
