/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.OafUtils;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupBuildRootsMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(DedupBuildRootsMapper.class);
    private DedupConfig dedupConf;
    private ImmutableBytesWritable ibw;
    private Set<String> entityNames;

    protected void setup(Mapper.Context context) {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup buildRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.entityNames = OafUtils.entities();
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.checkDataset(value)) {
            return;
        }
        NavigableMap mergedIn = value.getFamilyMap(DedupUtils.getDedupCF_mergedInBytes(TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType())));
        if (mergedIn != null && !mergedIn.isEmpty()) {
            HashSet<String> ids = this.getStrings(mergedIn);
            if (ids.size() > 1) {
                context.getCounter(this.dedupConf.getWf().getEntityType(), "mergedIn > 1").increment(1L);
            }
            Text rootId = new Text(Collections.min(ids));
            context.getCounter(this.dedupConf.getWf().getEntityType(), "merged").increment(1L);
            for (String family : this.dedupConf.getWf().getRootBuilder()) {
                NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)family));
                if (map == null || map.isEmpty()) continue;
                if (this.entityNames.contains(family)) {
                    OafProtos.Oaf body = UpdateMerger.mergeBodyUpdates(context, map);
                    this.emit(context, rootId, body.toByteArray());
                    continue;
                }
                for (byte[] o : map.values()) {
                    if (!this.isRelMarkedDeleted(context, o)) {
                        this.emit(context, rootId, o);
                        continue;
                    }
                    context.getCounter(family, "rel marked deleted").increment(1L);
                }
            }
        } else {
            byte[] body;
            NavigableMap mergesRels = value.getFamilyMap(DedupUtils.getDedupCF_mergesBytes(TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType())));
            if (mergesRels != null && !mergesRels.isEmpty() && (body = value.getValue(this.dedupConf.getWf().getEntityType().getBytes(), DedupUtils.BODY_B)) != null) {
                context.getCounter(this.dedupConf.getWf().getEntityType(), "root").increment(1L);
                this.emit(context, new Text(rowkey.copyBytes()), body);
            }
        }
    }

    private HashSet<String> getStrings(Map<byte[], byte[]> mergedIn) {
        return Sets.newHashSet((Iterable)Iterables.transform(mergedIn.keySet(), (Function)new Function<byte[], String>(){

            public String apply(byte[] input) {
                return new String(input);
            }
        }));
    }

    private boolean checkDataset(Result value) {
        NavigableMap bodyMap = value.getFamilyMap(this.dedupConf.getWf().getEntityType().getBytes());
        if (bodyMap == null || bodyMap.isEmpty()) {
            return true;
        }
        byte[] bodyB = (byte[])bodyMap.get(DedupUtils.BODY_B);
        if (bodyB == null) {
            return true;
        }
        OafProtos.OafEntity entity = OafDecoder.decode((byte[])bodyB).getEntity();
        return entity.getType().equals((Object)TypeProtos.Type.result) && entity.getResult().getMetadata().getResulttype().getClassid().equals("dataset");
    }

    private void emit(Mapper.Context context, Text rootId, byte[] value) throws IOException, InterruptedException {
        this.ibw.set(value);
        context.write((Object)rootId, (Object)this.ibw);
    }

    private boolean checkHack(byte[] rowkey, byte[] rootId, String family) {
        return this.dedupConf.getWf().getEntityType().equals(TypeProtos.Type.result.toString()) && family.equals(RelTypeProtos.RelType.personResult.toString()) && !rootId.equals(DedupUtils.newIdBytes(new String(rowkey), this.dedupConf.getWf().getDedupRun()));
    }

    private boolean isRelMarkedDeleted(Mapper.Context context, byte[] o) {
        try {
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])o);
            return oaf.getKind().equals((Object)KindProtos.Kind.relation) && oaf.getDataInfo().getDeletedbyinference();
        }
        catch (InvalidProtocolBufferException e) {
            context.getCounter("error", ((Object)((Object)e)).getClass().getName()).increment(1L);
            return true;
        }
    }
}

