/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.cc;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.TreeSet;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public final class VertexWritable
implements Writable,
Cloneable {
    private Text vertexId;
    private TreeSet<Text> edges;
    private boolean activated;

    public VertexWritable() {
    }

    public VertexWritable(Text minimalVertexId) {
        this.vertexId = minimalVertexId;
    }

    public boolean checkAndSetMinimalVertex(Text id) {
        if (this.vertexId == null) {
            this.vertexId = id;
            return true;
        }
        if (id.compareTo((BinaryComparable)this.vertexId) < 0) {
            this.vertexId = id;
            return true;
        }
        return false;
    }

    public boolean isMessage() {
        return this.edges == null;
    }

    public VertexWritable makeMessage() {
        return new VertexWritable(this.vertexId);
    }

    public void addVertex(Text id) {
        if (this.edges == null) {
            this.edges = new TreeSet();
        }
        this.edges.add(id);
    }

    public void write(DataOutput out) throws IOException {
        this.vertexId.write(out);
        if (this.edges == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.edges.size());
            for (Text l : this.edges) {
                l.write(out);
            }
        }
        out.writeBoolean(this.activated);
    }

    public void readFields(DataInput in) throws IOException {
        this.vertexId = new Text();
        this.vertexId.readFields(in);
        int length = in.readInt();
        if (length > -1) {
            this.edges = new TreeSet();
            for (int i = 0; i < length; ++i) {
                Text temp = new Text();
                temp.readFields(in);
                this.edges.add(temp);
            }
        } else {
            this.edges = null;
        }
        this.activated = in.readBoolean();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VertexWritable [minimalVertexId=").append(this.vertexId).append(", pointsTo=").append(this.edges).append("]");
        return sb.toString();
    }

    public static VertexWritable fromJSON(String json) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(VertexWritable.class, (Object)new JsonDeserializer<VertexWritable>(){

            public VertexWritable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jo = json.getAsJsonObject();
                VertexWritable vertexWritable = new VertexWritable();
                vertexWritable.setVertexId(new Text(jo.get("vertexId").getAsString()));
                vertexWritable.setActivated(jo.get("activated").getAsBoolean());
                TreeSet<Text> edges = new TreeSet<Text>();
                for (JsonElement e : jo.get("edges").getAsJsonArray()) {
                    edges.add(new Text(e.getAsString()));
                }
                vertexWritable.setEdges(edges);
                return vertexWritable;
            }
        });
        return (VertexWritable)builder.create().fromJson(json, VertexWritable.class);
    }

    public String toJSON() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(VertexWritable.class, (Object)new JsonSerializer<VertexWritable>(){

            public JsonElement serialize(VertexWritable src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject res = new JsonObject();
                res.addProperty("vertexId", VertexWritable.this.getVertexId().toString());
                res.addProperty("activated", Boolean.valueOf(VertexWritable.this.isActivated()));
                JsonArray edges = new JsonArray();
                if (!VertexWritable.this.isMessage()) {
                    for (Text edge : VertexWritable.this.getEdges()) {
                        edges.add((JsonElement)new JsonPrimitive(edge.toString()));
                    }
                }
                res.add("edges", (JsonElement)edges);
                return res;
            }
        });
        return builder.create().toJson((Object)this);
    }

    protected VertexWritable clone() {
        VertexWritable toReturn = new VertexWritable(new Text(this.vertexId.toString()));
        if (this.edges != null) {
            toReturn.edges = new TreeSet();
            for (Text l : this.edges) {
                toReturn.edges.add(new Text(l.toString()));
            }
        }
        return toReturn;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public Text getVertexId() {
        return this.vertexId;
    }

    public void setVertexId(Text vertexId) {
        this.vertexId = vertexId;
    }

    public TreeSet<Text> getEdges() {
        return this.edges;
    }

    public void setEdges(TreeSet<Text> edges) {
        this.edges = edges;
    }
}

