/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class PIDEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        new PIDEventFactory().processPID(context, current, other, trust);
    }

    public void processPID(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        if (current.getEntity().getPidList().isEmpty()) {
            for (FieldTypeProtos.StructuredProperty pidOther : other.getEntity().getPidList()) {
                this.doProcessPID(context, current, other, pidOther, Topic.ENRICH_MISSING_PID, trust);
            }
        }
        for (FieldTypeProtos.StructuredProperty pidOther : other.getEntity().getPidList()) {
            if (this.hasPidValue(current, pidOther.getValue())) continue;
            this.doProcessPID(context, current, other, pidOther, Topic.ENRICH_MORE_PID, trust);
        }
    }

    private void doProcessPID(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, FieldTypeProtos.StructuredProperty pidOther, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        prototype.getEntityBuilder().addPid(pidOther);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichPid(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), Lists.newArrayList((Object[])new FieldTypeProtos.StructuredProperty[]{pidOther}));
        EventMessage event = EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust);
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }

    private boolean hasPidValue(OafProtos.Oaf oaf, final String value) {
        return Iterables.any((Iterable)oaf.getEntity().getPidList(), (Predicate)new Predicate<FieldTypeProtos.StructuredProperty>(){

            public boolean apply(FieldTypeProtos.StructuredProperty pid) {
                return pid.getValue().equalsIgnoreCase(value);
            }
        });
    }
}

