/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.gt.Authors;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;
import eu.dnetlib.pace.model.gt.GTAuthorMapper;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupFindRootsPersonReducer
extends TableReducer<ImmutableBytesWritable, ImmutableBytesWritable, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Authors aas = new Authors();
        CoAuthors cas = new CoAuthors();
        for (GTAuthor a : this.asGTA(context, values)) {
            if (a.hasMerged()) {
                aas.addAll((Collection)a.getMerged());
            } else {
                aas.add((Object)a.getAuthor());
            }
            if (a.hasCoAuthors()) {
                cas.addAll((Collection)a.getCoAuthors());
            }
            byte[] row = Bytes.toBytes((String)a.getId());
            Delete delete = new Delete(row);
            this.outKey.set(row);
            context.write((Object)this.outKey, (Object)delete);
            context.getCounter(this.dedupConf.getWf().getEntityType(), "deleted").increment(1L);
        }
        String rootId = this.hashCodeString(aas);
        GTAuthor gta = new GTAuthor(rootId, aas, cas, true);
        Put put = new Put(Bytes.toBytes((String)gta.getId()));
        put.setWriteToWAL(true);
        put.add(Bytes.toBytes((String)this.dedupConf.getWf().getEntityType()), DedupUtils.BODY_B, this.toOafByteArray(gta));
        this.outKey.set(Bytes.toBytes((String)gta.getId()));
        context.write((Object)this.outKey, (Object)put);
        context.getCounter(this.dedupConf.getWf().getEntityType(), "out").increment(1L);
    }

    private Iterable<GTAuthor> asGTA(Reducer.Context context, Iterable<ImmutableBytesWritable> values) {
        return Iterables.transform(values, (Function)new Function<ImmutableBytesWritable, GTAuthor>(){

            public GTAuthor apply(ImmutableBytesWritable input) {
                return GTAuthor.fromJson((String)new String(input.copyBytes()));
            }
        });
    }

    public byte[] toOafByteArray(GTAuthor gta) {
        OafProtos.Oaf oaf = new GTAuthorMapper().map(gta);
        return oaf.toByteArray();
    }

    protected String hashCodeString(Authors ag) {
        return this.getRowKey(String.valueOf(ag.hashCode()));
    }

    protected String getRowKey(String s) {
        return AbstractDNetXsltFunctions.oafId((String)TypeProtos.Type.person.toString(), (String)"dedup_wf_001", (String)s);
    }

    private byte[] buildRel(byte[] from, byte[] to, DedupProtos.Dedup.RelName relClass) {
        OafProtos.OafRel.Builder oafRel = DedupUtils.getDedup(this.dedupConf, new String(from), new String(to), relClass);
        OafProtos.Oaf oaf = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setLastupdatetimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetXsltFunctions.getDataInfo(null, (String)"", (String)"0.8", (boolean)false, (boolean)true).setInferenceprovenance(this.dedupConf.getWf().getConfigurationId())).setRel(oafRel).build();
        return oaf.toByteArray();
    }

    private void emitDedupRel(Reducer.Context context, byte[] cf, byte[] from, byte[] to, byte[] value) throws IOException, InterruptedException {
        Put put = new Put(from).add(cf, to, value);
        put.setWriteToWAL(true);
        context.write((Object)new ImmutableBytesWritable(from), (Object)put);
    }
}

