package eu.dnetlib.data.mapreduce.hbase.actions;

import java.io.IOException;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;

public class CommitActionsMapper extends TableMapper<ImmutableBytesWritable, Put> {

	private String set = null;

	@Override
	protected void setup(Context context) throws IOException, InterruptedException {
		set = context.getConfiguration().get("set");
		if (set != null) {
			System.out.println("Committing set: " + set);
		} else {
			System.out.println("Committing ALL sets");
		}
	}

	@Override
	protected void map(ImmutableBytesWritable key, Result value, Context context) throws IOException, InterruptedException {

		if (set == null || value.getColumnLatest(Bytes.toBytes("set"), Bytes.toBytes(set)) != null) {
			System.out.println("Processing action " + Bytes.toString(key.copyBytes()));

			byte[] cf = Bytes.toBytes("target");

			byte[] tkey = value.getValue(cf, Bytes.toBytes("rowKey"));
			byte[] tcf = value.getValue(cf, Bytes.toBytes("columnFamily"));
			byte[] tc = value.getValue(cf, Bytes.toBytes("column"));
			byte[] tv = value.getValue(cf, Bytes.toBytes("content"));

			Put put = new Put(tkey);
			put.add(tcf, tc, tv);

			context.getCounter("Actions", Bytes.toString(tcf)).increment(1);

			context.write(new ImmutableBytesWritable(tkey), put);
		}
	}
}
