package eu.dnetlib.data.mapreduce.hbase.oai.utils;

import java.util.List;

/**
 * Collection of sets.
 *
 * @author michele
 *
 */
public interface SetCollection {

	/**
	 * Get all sets.
	 *
	 * @return list of SetInfo instances
	 */
	List<SetInfo> getAllSets(boolean enabledOnly, final String publisherDBName);

	/**
	 * Test if a set is in this collection.
	 *
	 * @param set
	 *            set spec
	 * @return true if the set is in this collection
	 */
	boolean containSet(final String set, final String publisherDBName);

	/**
	 * Test if a set is in this collection.
	 *
	 * @param set
	 *            set spec
	 * @return true if the set is in this collection
	 */
	boolean containEnabledSet(final String set, final String publisherDBName);

	/**
	 * Obtains the set query.
	 *
	 * @param set
	 *            set spec
	 * @return set CQL query
	 */
	String getSetQuery(final String set, final String publisherDBName);

	/**
	 *
	 * Gets the number of elements in the set with the given set spec for the given metadata prefix.
	 *
	 * @param setSpec
	 * @param mdPrefix
	 * @return -1 if the number of elements is unknown, 0 if the set is empty, a positive number otherwise.
	 */
	int count(final String setSpec, final String mdPrefix, final String publisherDBName);

}