/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class ProjectEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        new ProjectEventFactory().processProject(context, current, other, trust);
    }

    private void processProject(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        if (other == null) {
            for (OafProtos.OafRel rel : current.getEntity().getCachedRelList()) {
                this.doProcessProject(context, current, rel.getCachedTarget(), this.getProvenance(rel), Topic.ENRICH_MISSING_PROJECT, trust);
            }
        } else {
            for (OafProtos.OafRel currentRel : current.getEntity().getCachedRelList()) {
                for (OafProtos.OafRel otherRel : other.getEntity().getCachedRelList()) {
                    if (currentRel.getTarget().equals(otherRel.getTarget())) continue;
                    this.doProcessProject(context, current, other.getEntity(), this.getProvenance(otherRel), Topic.ENRICH_MISSING_PROJECT, trust);
                }
            }
        }
    }

    private String getProvenance(OafProtos.OafRel rel) {
        return ((FieldTypeProtos.KeyValue)Iterables.getOnlyElement((Iterable)rel.getCollectedfromList())).getKey();
    }

    private void doProcessProject(Reducer.Context context, OafProtos.Oaf current, OafProtos.OafEntity project, String provenance, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OpenAireEventPayload payload = OpenAireEventPayloadFactory.fromOAF(current.getEntity(), current.getEntity(), trust);
        EventMessage event = EventFactory.asEvent(current.getEntity(), topic, payload, current.getEntity(), trust);
        event.setPayload(HighlightFactory.highlightEnrichProject(payload, project, provenance).toJSON());
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }
}

