/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class EntityConfigTable
extends HashMap<TypeProtos.Type, EntityConfig> {
    private static final long serialVersionUID = 6087987206844928698L;

    public Collection<LinkDescriptor> getDescriptors(TypeProtos.Type source) {
        EntityConfig entityConfig = (EntityConfig)super.get(source);
        if (entityConfig == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(entityConfig.getLinks().values());
    }

    public LinkDescriptor getDescriptor(TypeProtos.Type type, RelDescriptor relDescriptor) {
        return ((EntityConfig)super.get(type)).getLinks().get(relDescriptor);
    }

    public Set<String> getFilter(TypeProtos.Type type, RelDescriptor relDescriptor) {
        LinkDescriptor ld = this.getDescriptor(type, relDescriptor);
        return ld != null ? Sets.newHashSet(ld.getFields()) : new HashSet<String>();
    }

    public boolean includeDuplicates(TypeProtos.Type type) {
        return ((EntityConfig)super.get(type)).getIndexDuplicates();
    }

    public boolean hasIncludeFields(TypeProtos.Type type) {
        return CollectionUtils.isNotEmpty(((EntityConfig)super.get(type)).getIncludeFields());
    }

    public boolean hasExcludeFields(TypeProtos.Type type) {
        return CollectionUtils.isNotEmpty(((EntityConfig)super.get(type)).getExcludeFields());
    }

    public List<String> getIncludeFields(TypeProtos.Type type) {
        return ((EntityConfig)super.get(type)).getIncludeFields();
    }

    public List<String> getExcludeFields(TypeProtos.Type type) {
        return ((EntityConfig)super.get(type)).getExcludeFields();
    }

    public Predicate<String> getIncludeFilter(TypeProtos.Type type, RelDescriptor relDescriptor) {
        Set<String> filter = this.getFilter(type, relDescriptor);
        return fieldName -> filter.contains(fieldName);
    }

    public Predicate<String> getFilter(TypeProtos.Type type) {
        if (this.hasIncludeFields(type)) {
            return this.getIncludeFilter(type);
        }
        if (this.hasExcludeFields(type)) {
            return this.getExcludeFilter(type);
        }
        return Predicates.alwaysTrue();
    }

    private Predicate<String> getIncludeFilter(TypeProtos.Type type) {
        return fieldName -> {
            if (this.getIncludeFields(type) == null || this.getIncludeFields(type).isEmpty()) {
                return false;
            }
            return this.getIncludeFields(type).contains(fieldName);
        };
    }

    private Predicate<String> getExcludeFilter(TypeProtos.Type type) {
        return fieldName -> {
            if (this.getExcludeFields(type) == null || this.getExcludeFields(type).isEmpty()) {
                return true;
            }
            return !this.getExcludeFields(type).contains(fieldName);
        };
    }
}

