package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.*;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.apache.commons.collections.CollectionUtils;

public class EntityConfigTable extends HashMap<TypeProtos.Type, EntityConfig> {

	private static final long serialVersionUID = 6087987206844928698L;

	public Collection<LinkDescriptor> getDescriptors(final Type source) {
		final EntityConfig entityConfig = super.get(source);
		if (entityConfig == null) return Lists.newArrayList();
		return Lists.newArrayList(entityConfig.getLinks().values());
	}

	public LinkDescriptor getDescriptor(final Type type, final RelDescriptor relDescriptor) {
		return super.get(type).getLinks().get(relDescriptor);
	}

	public Set<String> getFilter(final Type type, final RelDescriptor relDescriptor) {
		final LinkDescriptor ld = getDescriptor(type, relDescriptor);
		return ld != null ? Sets.newHashSet(ld.getFields()) : new HashSet<String>();
	}

	public boolean includeDuplicates(final Type type) {
		return super.get(type).getIndexDuplicates();
	}

	public boolean hasIncludeFields(final Type type){
		return CollectionUtils.isNotEmpty(super.get(type).getIncludeFields());
	}

	public boolean hasExcludeFields(final Type type){
		return CollectionUtils.isNotEmpty(super.get(type).getExcludeFields());
	}

	public List<String> getIncludeFields(final Type type){
		return super.get(type).getIncludeFields();
	}

	public List<String> getExcludeFields(final Type type){
		return super.get(type).getExcludeFields();
	}

	public Predicate<String> getIncludeFilter(final Type type, final RelDescriptor relDescriptor){
		final Set<String> filter = getFilter(type, relDescriptor);
		return fieldName -> filter.contains(fieldName);
	}

	public Predicate<String> getFilter(final Type type){
		if(hasIncludeFields(type)){
			return getIncludeFilter(type);
		}
		if(hasExcludeFields(type)){
			return getExcludeFilter(type);
		}
		return Predicates.alwaysTrue();
	}

	private Predicate<String> getIncludeFilter(final Type type) {
		return fieldName -> {
			if(getIncludeFields(type) == null || getIncludeFields(type).isEmpty()) return false;
			return getIncludeFields(type).contains(fieldName);
		};
	}

	private Predicate<String> getExcludeFilter(final Type type) {
		return fieldName -> {
			if(getExcludeFields(type) == null || getExcludeFields(type).isEmpty()) return true;
			return !getExcludeFields(type).contains(fieldName);
		};
	}


}