/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import eu.dnetlib.data.mapreduce.hbase.broker.CalculatePersonDistributionUtils;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class CalculatePersonDistributionStep1Mapper
extends TableMapper<Text, Text> {
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    protected void map(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (DedupUtils.isRoot(key)) {
            return;
        }
        OafRowKeyDecoder kd = OafRowKeyDecoder.decode((byte[])key.copyBytes());
        context.getCounter("MAPPER: processed rows", kd.getType().name()).increment(1L);
        switch (kd.getType()) {
            case result: {
                this.processResult(result, context);
                break;
            }
            case datasource: {
                this.processDatasource(result, context);
            }
        }
    }

    private void processResult(Result result, Mapper.Context context) throws IOException, InterruptedException {
        byte[] body = result.getValue(Bytes.toBytes((String)"result"), Bytes.toBytes((String)"body"));
        if (body == null) {
            context.getCounter("MAPPER: errors", "result body is null").increment(1L);
            return;
        }
        OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
        ResultProtos.Result r = oaf.getEntity().getResult();
        if (r != null) {
            for (PersonProtos.Person p : r.getAuthorList()) {
                for (FieldTypeProtos.KeyValue kv : oaf.getEntity().getCollectedfromList()) {
                    String dsId = kv.getKey();
                    String pValue = CalculatePersonDistributionUtils.createPersonValue(p);
                    if (StringUtils.isNotBlank((String)dsId) && StringUtils.isNotBlank((String)pValue)) {
                        context.write((Object)new Text(dsId), (Object)new Text(pValue));
                        context.getCounter("MAPPER: emitted entities", "person").increment(1L);
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)dsId)) {
                        context.getCounter("MAPPER: errors", "person without firstname/secondnames").increment(1L);
                        continue;
                    }
                    context.getCounter("MAPPER: errors", "collectedFrom is blank").increment(1L);
                }
            }
        }
    }

    private void processDatasource(Result result, Mapper.Context context) throws IOException, InterruptedException {
        byte[] body = result.getValue(Bytes.toBytes((String)"datasource"), Bytes.toBytes((String)"body"));
        if (body == null) {
            context.getCounter("MAPPER: errors", "datasource body is null").increment(1L);
            return;
        }
        OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
        DatasourceProtos.Datasource ds = oaf.getEntity().getDatasource();
        if (ds != null) {
            context.write((Object)new Text(oaf.getEntity().getId()), (Object)new Text(CalculatePersonDistributionUtils.createDsTypeValue(ds)));
            context.getCounter("MAPPER: emitted entities", "datasource").increment(1L);
        }
    }
}

