/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class PublicationDateEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        new PublicationDateEventFactory().processPublicationDate(context, current, other, trust);
    }

    private void processPublicationDate(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        if (this.hasPubDate(other) && !this.hasPubDate(current)) {
            this.doProcessPublicationDate(context, current, other, Topic.ENRICH_MISSING_PUBLICATION_DATE, trust);
        }
    }

    private void doProcessPublicationDate(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        FieldTypeProtos.StringField date = other.getEntity().getResult().getMetadata().getDateofacceptance();
        prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().setDateofacceptance(date);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichPublicationDate(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), date);
        EventMessage event = EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust);
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }

    private boolean hasPubDate(OafProtos.Oaf current) {
        ResultProtos.Result.Metadata m = current.getEntity().getResult().getMetadata();
        return StringUtils.isNotBlank((String)m.getDateofacceptance().getValue());
    }
}

