/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

public class CalculatePersonDistributionUtils {
    public static final String SEPARATOR = "||@@||";
    private static final String PERSON_PREFIX = "PERSON||@@||";
    private static final String DS_TYPE_PREFIX = "DSTYPE||@@||";

    public static String createPersonValue(PersonProtos.Person p) {
        try {
            String fn = p.getMetadata().getFirstname().getValue();
            String sn = "";
            for (FieldTypeProtos.StringField sf : p.getMetadata().getSecondnamesList()) {
                sn = sn + sf.getValue();
            }
            if (StringUtils.isNotBlank((String)fn) && StringUtils.isNotBlank((String)sn)) {
                return PERSON_PREFIX + sn + "_" + fn.substring(0, 1);
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String createDsTypeValue(DatasourceProtos.Datasource ds) {
        return DS_TYPE_PREFIX + ds.getMetadata().getDatasourcetype().getClassid();
    }

    public static boolean isPerson(byte[] b) {
        return Bytes.toString((byte[])b).startsWith(PERSON_PREFIX);
    }

    public static boolean isDsType(byte[] b) {
        return Bytes.toString((byte[])b).startsWith(DS_TYPE_PREFIX);
    }

    public static String getPersonName(byte[] b) {
        return StringUtils.substringAfter((String)Bytes.toString((byte[])b), (String)PERSON_PREFIX);
    }

    public static String getType(byte[] b) {
        return StringUtils.substringAfter((String)Bytes.toString((byte[])b), (String)DS_TYPE_PREFIX);
    }

    public static Text prepareHdfsValue(String dsId, String name) {
        return new Text(dsId + SEPARATOR + name);
    }

    public static Text prepareHdfsKey(String dsId, int count) {
        return new Text(dsId + "_" + count);
    }

    public static Text getDsIdFromHdfsValue(Text text) {
        return new Text(StringUtils.substringBefore((String)Bytes.toString((byte[])text.copyBytes()), (String)SEPARATOR));
    }

    public static Text getNameFromHdfsValue(Text text) {
        return new Text(StringUtils.substringAfter((String)Bytes.toString((byte[])text.copyBytes()), (String)SEPARATOR));
    }
}

