/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.broker.objects.ExternalReference;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.Journal;
import eu.dnetlib.broker.objects.Pid;
import eu.dnetlib.broker.objects.Project;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class ProtoMapping {
    protected static List<Instance> mapInstances(List<ResultProtos.Result.Instance> in) {
        HashSet instances = Sets.newHashSet((Iterable)Iterables.transform(in, (Function)new Function<ResultProtos.Result.Instance, Instance>(){

            public Instance apply(ResultProtos.Result.Instance i) {
                return new Instance().setHostedby(OafHbaseUtils.getValue(i.getHostedby())).setInstancetype(OafHbaseUtils.getValue(i.getInstancetype())).setLicense(OafHbaseUtils.getKey(i.getLicence())).setUrl((String)Iterables.getFirst((Iterable)i.getUrlList(), (Object)""));
            }
        }));
        return Lists.newArrayList((Iterable)instances);
    }

    protected static List<Pid> mapPids(List<FieldTypeProtos.StructuredProperty> sp) {
        return Lists.newArrayList((Iterable)Iterables.transform(sp, (Function)new Function<FieldTypeProtos.StructuredProperty, Pid>(){

            public Pid apply(FieldTypeProtos.StructuredProperty sp) {
                return new Pid().setType(sp.getQualifier().getClassid()).setValue(sp.getValue());
            }
        }));
    }

    protected static Journal mapJournal(ResultProtos.Result.Journal j) {
        return new Journal().setName(j.getName()).setIssn(j.getIssnPrinted()).setEissn(j.getIssnOnline()).setLissn(j.getIssnLinking());
    }

    protected static List<ExternalReference> mapExternalRefs(List<ResultProtos.Result.ExternalReference> ext) {
        return Lists.newArrayList((Iterable)Iterables.transform(ext, (Function)new Function<ResultProtos.Result.ExternalReference, ExternalReference>(){

            public ExternalReference apply(ResultProtos.Result.ExternalReference e) {
                return new ExternalReference().setUrl(e.getUrl()).setType(OafHbaseUtils.getKey(e.getQualifier())).setRefidentifier(e.getRefidentifier()).setSitename(e.getSitename());
            }
        }));
    }

    protected static final List<Project> mapRelatedProjects(OafProtos.OafEntity entity) {
        HashMap projectMap = Maps.newHashMap();
        for (OafProtos.Oaf rel : entity.getCachedOafRelList()) {
            OafProtos.OafEntity p = rel.getRel().getCachedOafTarget().getEntity();
            projectMap.put(p.getId(), OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel).build());
        }
        return Lists.transform((List)Lists.newArrayList(projectMap.values()), ProtoMapping.getProjectMappingFunction());
    }

    protected static final Project mapRelatedProject(ProjectProtos.Project project) {
        Project p = new Project();
        ProjectProtos.Project.Metadata mp = project.getMetadata();
        p.setCode(OafHbaseUtils.getValue(mp.getCode()));
        p.setAcronym(OafHbaseUtils.getValue(mp.getAcronym()));
        p.setTitle(OafHbaseUtils.getValue(mp.getTitle()));
        String ftree = OafHbaseUtils.getValue(mp.getFundingtreeList());
        if (StringUtils.isNotBlank((String)ftree)) {
            try {
                Document fdoc = new SAXReader().read((Reader)new StringReader(ftree));
                p.setFunder(fdoc.valueOf("/fundingtree/funder/shortname"));
                p.setJurisdiction(fdoc.valueOf("/fundingtree/funder/jurisdiction"));
                p.setFundingProgram(fdoc.valueOf("//funding_level_0/name"));
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }
        return p;
    }

    private static Function<OafProtos.Oaf, Project> getProjectMappingFunction() {
        return new Function<OafProtos.Oaf, Project>(){

            public Project apply(OafProtos.Oaf oafRel) {
                return ProtoMapping.mapRelatedProject(oafRel.getRel().getCachedOafTarget().getEntity().getProject());
            }
        };
    }
}

