package eu.dnetlib.data.mapreduce.hbase.dedup.gt;

import java.io.IOException;
import java.util.Map;

import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.PersonProtos.Person.MergedPerson;
import eu.dnetlib.data.proto.TypeProtos.Type;

/**
 * builds map {merged author -> anchorId}
 *
 * @author claudio
 *
 */
public class BuildMergedAnchorMapMapper extends TableMapper<ImmutableBytesWritable, Text> {

	private ImmutableBytesWritable outKey;

	private Text outValue;

	@SuppressWarnings("serial")
	final java.lang.reflect.Type token = new TypeToken<Map<String, String>>() {}.getType();

	private Gson gson;

	@Override
	protected void setup(final Context context) {
		outKey = new ImmutableBytesWritable(Bytes.toBytes("1"));
		outValue = new Text();

		gson = new Gson();
	}

	@Override
	protected void map(final ImmutableBytesWritable rowkey, final Result value, final Context context) throws IOException, InterruptedException {

		final OafRowKeyDecoder rkd = OafRowKeyDecoder.decode(rowkey.copyBytes());

		if (!Type.person.equals(rkd.getType())) {
			context.getCounter(rkd.getType().toString(), "skipped").increment(1);
		}

		final byte[] body = value.getValue(Bytes.toBytes(Type.person.toString()), DedupUtils.BODY_B);

		final OafDecoder d = OafDecoder.decode(body);

		final String anchorId = d.getEntity().getId();
		final Map<String, String> map = Maps.newHashMap();

		for (final MergedPerson p : d.getEntity().getPerson().getMergedpersonList()) {
			map.put(p.getId(), anchorId);
		}

		outValue.set(gson.toJson(map, token));

		context.write(outKey, outValue);

	}
}
