package eu.dnetlib.data.mapreduce.hbase.actions;

import java.io.IOException;

import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;

public class DeleteActionsMapper extends TableMapper<ImmutableBytesWritable, Delete> {

	private String set = null;

	@Override
	protected void setup(Context context) throws IOException, InterruptedException {
		set = context.getConfiguration().get("set");
		if (set != null) {
			System.out.println("Deleting set: " + set);
		} else {
			System.out.println("Deleting ALL sets");
		}
	}

	@Override
	protected void map(ImmutableBytesWritable key, Result value, Context context) throws IOException, InterruptedException {
		if (set == null || value.getColumnLatest(Bytes.toBytes("set"), Bytes.toBytes(set)) != null) {

			final byte[] rowKey = key.copyBytes();
			System.out.println("Deleting action " + Bytes.toString(rowKey));

			context.getCounter("Actions", "N. Deletes").increment(1);
			context.write(key, new Delete(rowKey));
		}
	}
}
