package eu.dnetlib.data.mapreduce.hbase.broker;

import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

/**
 * Created by michele on 12/10/15.
 */
public class CalculatePersonDistributionStep2Mapper extends Mapper<Text, Text, Text, Text> {

	@Override
	protected void setup(final Mapper.Context context) throws IOException, InterruptedException {
		super.setup(context);
	}

	@Override
	protected void map(final Text key, final Text value, final Context context) throws IOException, InterruptedException {
		// key: person fullname
		// value: dsId
		context.write(
				CalculatePersonDistributionUtils.getNameFromHdfsValue(value),
				CalculatePersonDistributionUtils.getDsIdFromHdfsValue(value)
		);
	}
}
