/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class AbstractEnrichmentMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    protected ImmutableBytesWritable outValue;
    protected ImmutableBytesWritable outKey;

    protected abstract String counterGroup();

    protected void setup(Mapper.Context context) {
        this.outKey = new ImmutableBytesWritable();
        this.outValue = new ImmutableBytesWritable();
    }

    protected void emit(Mapper.Context context, byte[] key, byte[] value, String entityType) {
        this.outKey.set(key);
        this.outValue.set(value);
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
            context.getCounter(this.counterGroup(), "entity type: " + entityType).increment(1L);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

