package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import java.io.IOException;
import java.util.List;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.broker.*;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.dom4j.DocumentException;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getKey;

/**
 * Created by claudio on 08/07/16.
 */
public class EnrichmentReducer extends AbstractEnrichmentReducer {

	@Override
	protected String counterGroup() {
		return "Broker Enrichment";
	}

	@Override
	protected void reduce(final ImmutableBytesWritable key, final Iterable<ImmutableBytesWritable> values, final Context context) throws IOException,
			InterruptedException {

		final List<Oaf> oafList = Lists.newArrayList(Iterables.transform(Iterables.limit(values, LIMIT), oafDeserialiser()));

		try {
			generateEvents(oafList, context);
		} catch (final DocumentException e) {
			throw new RuntimeException(e);
		}
	}

	private void generateEvents(final List<Oaf> oafList, final Context context) throws IOException, InterruptedException, DocumentException {

		for (final Oaf current : oafList) {

			final String currentId = current.getEntity().getId();

			final String currentDsId = StringUtils.substringAfter(getKey(current.getEntity().getCollectedfromList()), "|");
			final String currentDsType = dsTypeMap.get(currentDsId);

			// System.out.println(String.format("'%s' -> '%s'", currentDsId, currentDsType));

			if (StringUtils.isBlank(currentDsType) && !dsWhitelist.contains(currentDsId)) {
				context.getCounter("events skipped", "datasource type excluded").increment(1);
			} else {
				if (dsBlacklist.contains(currentDsId)) {
					context.getCounter("events skipped", "datasource blacklisted").increment(1);
				} else {
					for (final Oaf other : oafList) {

						final String otherId = other.getEntity().getId();
						if (!currentId.equals(otherId)) {

							final float trust = similarity(current, other);

							if (!DedupUtils.isRoot(current.getEntity().getId())) {
								PIDEventFactory.process(context, current, other, trust);
								OAVersionEventFactory.process(context, current, other, trust, untrustedOaDsList);
								AbstractEventFactory.process(context, current, other, trust);
								PublicationDateEventFactory.process(context, current, other, trust);
							}
							SubjectEventFactory.process(context, current, other, trust);

						} else if (oafList.size() == 1) {
							SubjectEventFactory.process(context, current);
						}
					}
				}
			}
		}
	}

}
