/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.mapreduce.hbase.broker.ProjectEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.enrich.AbstractEnrichmentReducer;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class ProjectEnrichmentReducer
extends AbstractEnrichmentReducer {
    @Override
    protected String counterGroup() {
        return "Broker Enrichment projects";
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        HashMap projects = Maps.newHashMap();
        ArrayList pubs = Lists.newArrayList();
        block6: for (OafProtos.Oaf oaf : Iterables.transform((Iterable)Iterables.limit(values, (int)1000), this.oafDeserialiser())) {
            switch (oaf.getEntity().getType()) {
                case result: {
                    pubs.add(oaf);
                    continue block6;
                }
                case project: {
                    projects.put(oaf.getEntity().getId(), oaf);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("invalid type: " + oaf.getEntity().getType());
        }
        if (projects.isEmpty() || pubs.isEmpty()) {
            context.getCounter(this.counterGroup(), "Events Skipped - Nothing to do").increment(1L);
            return;
        }
        try {
            this.generateEvents(pubs, projects, context);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateEvents(List<OafProtos.Oaf> pubs, final Map<String, OafProtos.Oaf> projects, Reducer.Context context) throws IOException, InterruptedException, DocumentException {
        ArrayList enrichedOaf = Lists.newArrayList((Iterable)Iterables.transform(pubs, (Function)new Function<OafProtos.Oaf, OafProtos.Oaf>(){

            public OafProtos.Oaf apply(OafProtos.Oaf pub) {
                return ProjectEnrichmentReducer.this.addProjects(pub, projects);
            }
        }));
        ArrayList valid = Lists.newArrayList((Iterable)Iterables.filter((Iterable)enrichedOaf, (Predicate)new Predicate<OafProtos.Oaf>(){

            public boolean apply(OafProtos.Oaf result) {
                return !result.getEntity().getCachedOafRelList().isEmpty();
            }
        }));
        if (valid.isEmpty()) {
            context.getCounter(this.counterGroup(), "Events Skipped - Missing project").increment(1L);
            return;
        }
        for (OafProtos.Oaf current : valid) {
            String currentId = current.getEntity().getId();
            String currentDsId = StringUtils.substringAfter((String)OafHbaseUtils.getKey(current.getEntity().getCollectedfromList()), (String)"|");
            String currentDsType = (String)this.dsTypeMap.get(currentDsId);
            if (StringUtils.isBlank((String)currentDsType) && !this.dsWhitelist.contains(currentDsId)) {
                context.getCounter(this.counterGroup(), "Events Skipped - Datasource type excluded").increment(1L);
                continue;
            }
            if (this.dsBlacklist.contains(currentDsId)) {
                context.getCounter(this.counterGroup(), "Events Skipped - Datasource blacklisted").increment(1L);
                continue;
            }
            if (valid.size() == 1) {
                ProjectEventFactory.process(context, (OafProtos.Oaf)valid.get(0));
                return;
            }
            for (OafProtos.Oaf other : valid) {
                String otherId = other.getEntity().getId();
                if (currentId.equals(otherId)) continue;
                float trust = this.similarity(current, other);
                ProjectEventFactory.process(context, current, other, Float.valueOf(trust));
            }
        }
    }

    private OafProtos.Oaf addProjects(OafProtos.Oaf current, Map<String, OafProtos.Oaf> projects) {
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        ArrayList cachedRels = Lists.newArrayList();
        for (OafProtos.Oaf.Builder cachedOafRel : oafBuilder.getEntityBuilder().getCachedOafRelBuilderList()) {
            String projectId = cachedOafRel.getRel().getTarget();
            if (!projects.containsKey(projectId)) continue;
            OafProtos.Oaf project = projects.get(projectId);
            cachedOafRel.getRelBuilder().setCachedOafTarget(project);
            cachedRels.add(cachedOafRel.build());
        }
        oafBuilder.getEntityBuilder().clearCachedOafRel().addAllCachedOafRel((Iterable)cachedRels);
        return oafBuilder.build();
    }
}

