/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.gt;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class GTCleanerMapper
extends TableMapper<ImmutableBytesWritable, Delete> {
    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        TypeProtos.Type type = keyDecoder.getType();
        if (!type.equals((Object)TypeProtos.Type.person)) {
            this.incrementCounter(context, "wrong entity type", type.toString(), 1);
            return;
        }
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)type.toString()));
        byte[] bodyB = (byte[])map.get(DedupUtils.BODY_B);
        if (bodyB == null) {
            this.incrementCounter(context, "missing body (map)", type.toString(), 1);
            return;
        }
        OafProtos.Oaf oaf = this.decodeProto(context, bodyB);
        if (!this.isValid(oaf)) {
            this.incrementCounter(context, "missing body (map)", type.toString(), 1);
            return;
        }
        if (this.mergedSize(oaf, 0) || this.mergedSize(oaf, 1)) {
            context.write((Object)keyIn, (Object)new Delete(keyIn.copyBytes()));
            this.incrementCounter(context, KindProtos.Kind.entity.toString(), "deleted", 1);
        }
    }

    private boolean mergedSize(OafProtos.Oaf oaf, int size) {
        OafProtos.OafEntity entity = oaf.getEntity();
        if (entity == null) {
            return false;
        }
        PersonProtos.Person person = entity.getPerson();
        return person.getMergedpersonList() != null && person.getMergedpersonList().size() == size;
    }

    private boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }

    private OafProtos.Oaf decodeProto(Mapper.Context context, byte[] body) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])body);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace(System.err);
            context.getCounter("decodeProto", ((Object)((Object)e)).getClass().getName()).increment(1L);
            return null;
        }
    }

    private void incrementCounter(Mapper.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Mapper.Context context, String k, String t) {
        return context.getCounter(k, t);
    }
}

