/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import eu.dnetlib.data.mapreduce.hbase.broker.CalculatePersonDistributionUtils;
import java.io.IOException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class CalculatePersonDistributionStep1Reducer
extends Reducer<Text, Text, Text, Text> {
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        String dsID = Bytes.toString((byte[])key.getBytes());
        int count = 0;
        String type = null;
        for (Text i : values) {
            byte[] b = i.copyBytes();
            if (count == 0) {
                if (!CalculatePersonDistributionUtils.isDsType(b)) {
                    System.err.println("Invalid record in iterable (expected dsType): " + Bytes.toString((byte[])b));
                    context.getCounter("REDUCER: Invalid record in iterable", "expected dsType").increment(1L);
                    return;
                }
                type = CalculatePersonDistributionUtils.getType(b);
                if (!type.equals("pubsrepository::institutional")) {
                    context.getCounter("REDUCER: Skipped Datasource Typologies", type).increment(1L);
                    return;
                }
                context.getCounter("REDUCER: Valid Datasource Typologies (all)", type).increment(1L);
            } else {
                if (!CalculatePersonDistributionUtils.isPerson(b)) {
                    System.err.println("Invalid record in iterable (expected person): " + Bytes.toString((byte[])b));
                    context.getCounter("REDUCER: Invalid record in iterable", "expected person").increment(1L);
                    return;
                }
                context.write((Object)CalculatePersonDistributionUtils.prepareHdfsKey(dsID, count), (Object)CalculatePersonDistributionUtils.prepareHdfsValue(dsID, CalculatePersonDistributionUtils.getPersonName(b)));
                if (count == 1) {
                    context.getCounter("REDUCER: Valid Datasource Typologies (with persons)", type).increment(1L);
                }
            }
            ++count;
        }
        if (type != null && count > 0) {
            context.getCounter("REDUCER: Person occurrences", type).increment((long)(count - 1));
        }
    }
}

