/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextDef;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.LicenseComparator;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.mapreduce.util.TemplateFactory;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.miscutils.collections.MappedCollection;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;

public class XmlRecordFactory {
    private final Map<String, Integer> relCounters = Maps.newHashMap();
    protected Set<String> specialDatasourceTypes;
    protected TemplateFactory templateFactory = new TemplateFactory();
    protected OafDecoder mainEntity = null;
    protected String key = null;
    protected List<OafDecoder> relations = Lists.newLinkedList();
    protected List<OafDecoder> children = Lists.newLinkedList();
    protected EntityConfigTable entityConfigTable;
    protected ContextMapper contextMapper;
    protected RelClasses relClasses;
    protected String schemaLocation;
    protected boolean entityDefaults;
    protected boolean relDefaults;
    protected boolean childDefaults;
    protected Set<String> contextes = Sets.newHashSet();
    protected List<String> extraInfo = Lists.newArrayList();
    protected Map<String, Integer> counters = Maps.newHashMap();
    protected Transformer transformer;
    protected static Predicate<String> instanceFilter = new Predicate<String>(){
        final Set<String> instanceFieldFilter = Sets.newHashSet((Object[])new String[]{"instancetype", "hostedby", "licence", "collectedfrom", "dateofacceptance"});

        public boolean apply(String s) {
            return this.instanceFieldFilter.contains(s);
        }
    };

    public XmlRecordFactory(EntityConfigTable entityConfigTable, ContextMapper contextMapper, RelClasses relClasses, String schemaLocation, boolean entityDefaults, boolean relDefaults, boolean childDefeaults, Set<String> otherDatasourceTypesUForUI) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        this.entityConfigTable = entityConfigTable;
        this.contextMapper = contextMapper;
        this.relClasses = relClasses;
        this.schemaLocation = schemaLocation;
        this.entityDefaults = entityDefaults;
        this.relDefaults = relDefaults;
        this.childDefaults = childDefeaults;
        this.specialDatasourceTypes = otherDatasourceTypesUForUI;
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
    }

    public static String removePrefix(String s) {
        if (s.contains("|")) {
            return StringUtils.substringAfter((String)s, (String)"|");
        }
        return s;
    }

    public static String escapeXml(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public Map<String, Integer> getRelCounters() {
        return this.relCounters;
    }

    public RelClasses getRelClasses() {
        return this.relClasses;
    }

    public String getId() {
        return this.key;
    }

    public boolean isValid() {
        return this.mainEntity != null;
    }

    public void setMainEntity(OafDecoder mainEntity) {
        this.mainEntity = mainEntity;
        this.key = mainEntity.decodeEntity().getId();
    }

    public void addRelation(TypeProtos.Type type, OafDecoder rel) {
        this.addRelOrChild(type, this.relations, rel);
    }

    public void addChild(TypeProtos.Type type, OafDecoder child) {
        this.addRelOrChild(type, this.children, child);
    }

    private void addRelOrChild(TypeProtos.Type type, List<OafDecoder> list, OafDecoder decoder) {
        OafProtos.OafRel oafRel = decoder.getOafRel();
        String rd = oafRel.getRelType().toString() + "_" + oafRel.getSubRelType() + "_" + this.relClasses.getInverse(oafRel.getRelClass());
        LinkDescriptor ld = this.entityConfigTable.getDescriptor(type, new RelDescriptor(rd));
        if (this.getRelCounters().get(rd) == null) {
            this.getRelCounters().put(rd, 0);
        }
        if (ld == null) {
            list.add(decoder);
            return;
        }
        if (ld.getMax() < 0) {
            list.add(decoder);
            return;
        }
        if (this.getRelCounters().get(rd) < ld.getMax()) {
            this.getRelCounters().put(rd, this.getRelCounters().get(rd) + 1);
            list.add(decoder);
        }
    }

    public String build() {
        try {
            OafEntityDecoder entity = this.mainEntity.decodeEntity();
            Predicate<String> filter = this.entityConfigTable.getFilter(entity.getType());
            List<String> metadata = this.decodeType(entity, filter, this.entityDefaults, false);
            List<String> rels = this.listRelations();
            metadata.addAll(this.buildContexts(entity.getType()));
            metadata.add(this.parseDataInfo(this.mainEntity));
            String body = this.templateFactory.buildBody(entity.getType(), metadata, rels, this.listChildren(), this.extraInfo);
            return this.templateFactory.buildRecord(this.key, entity.getDateOfCollection(), entity.getDateOfTransformation(), this.schemaLocation, body, this.countersAsXml());
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("error building record '%s'", this.key), e);
        }
    }

    private String parseDataInfo(OafDecoder decoder) {
        FieldTypeProtos.DataInfo dataInfo = decoder.getOaf().getDataInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("<datainfo>");
        sb.append(this.asXmlElement("inferred", dataInfo.getInferred() + "", null, null));
        sb.append(this.asXmlElement("deletedbyinference", dataInfo.getDeletedbyinference() + "", null, null));
        sb.append(this.asXmlElement("trust", dataInfo.getTrust() + "", null, null));
        sb.append(this.asXmlElement("inferenceprovenance", dataInfo.getInferenceprovenance() + "", null, null));
        sb.append(this.asXmlElement("provenanceaction", null, dataInfo.getProvenanceaction(), null));
        sb.append("</datainfo>");
        return sb.toString();
    }

    private List<String> decodeType(OafEntityDecoder decoder, Predicate<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        metadata.addAll(this.listFields(decoder.getMetadata(), filter, defaults, expandingRel));
        metadata.addAll(this.listFields(decoder.getOafEntity(), filter, defaults, expandingRel));
        if (decoder.getEntity() instanceof ResultProtos.Result && !expandingRel) {
            metadata.add(this.asXmlElement("bestlicense", "", this.getBestLicense(), null));
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        if (decoder.getEntity() instanceof PersonProtos.Person && !expandingRel) {
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        if (decoder.getEntity() instanceof ProjectProtos.Project && !expandingRel) {
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        return metadata;
    }

    private FieldTypeProtos.Qualifier getBestLicense() {
        FieldTypeProtos.Qualifier bestLicense = this.getQualifier("UNKNOWN", "not available", "dnet:access_modes");
        LicenseComparator lc = new LicenseComparator();
        for (ResultProtos.Result.Instance instance : ((ResultProtos.Result)this.mainEntity.decodeEntity().getEntity()).getInstanceList()) {
            if (lc.compare(bestLicense, instance.getLicence()) <= 0) continue;
            bestLicense = instance.getLicence();
        }
        return bestLicense;
    }

    public FieldTypeProtos.Qualifier getQualifier(String classid, String classname, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemename).setSchemename(schemename).build();
    }

    private List<String> listRelations() {
        ArrayList rels = Lists.newArrayList();
        for (OafDecoder decoder : this.relations) {
            RelMetadataProtos.RelMetadata relMetadata;
            OafProtos.OafRel rel = decoder.getOafRel();
            OafProtos.OafEntity cachedTarget = rel.getCachedTarget();
            OafRelDecoder relDecoder = OafRelDecoder.decode((OafProtos.OafRel)rel);
            if (!relDecoder.getRelSourceId().equals(this.key) && !relDecoder.getRelTargetId().equals(this.key)) continue;
            ArrayList metadata = Lists.newArrayList();
            TypeProtos.Type targetType = relDecoder.getTargetType(this.mainEntity.getEntity().getType());
            metadata.addAll(this.listFields(relDecoder.getSubRel(), this.entityConfigTable.getIncludeFilter(targetType, relDecoder.getRelDescriptor()), false, true));
            String semanticclass = "";
            String semanticscheme = "";
            RelDescriptor relDescriptor = relDecoder.getRelDescriptor();
            if (cachedTarget != null && cachedTarget.isInitialized()) {
                OafEntityDecoder d = OafEntityDecoder.decode((OafProtos.OafEntity)cachedTarget);
                metadata.addAll(this.decodeType(d, this.entityConfigTable.getIncludeFilter(targetType, relDescriptor), this.relDefaults, true));
                if (d.getType().equals((Object)TypeProtos.Type.result)) {
                    for (ResultProtos.Result.Instance i : cachedTarget.getResult().getInstanceList()) {
                        List<String> fields = this.listFields((GeneratedMessage)i, this.entityConfigTable.getIncludeFilter(targetType, relDecoder.getRelDescriptor()), false, true);
                        metadata.addAll(fields);
                    }
                }
            }
            if ((relMetadata = relDecoder.getRelMetadata()) == null) {
                semanticscheme = "UNKNOWN";
                semanticclass = "UNKNOWN";
            } else {
                semanticclass = this.relClasses.getInverse(relMetadata.getSemantics().getClassname());
                semanticscheme = relMetadata.getSemantics().getSchemename();
            }
            String rd = relDescriptor.getSubRelType().toString();
            this.incrementCounter(rd);
            FieldTypeProtos.DataInfo info = decoder.getOaf().getDataInfo();
            if (info.getInferred()) {
                this.incrementCounter(rd + "_inferred");
            } else if (StringUtils.startsWith((String)info.getProvenanceaction().getClassid(), (String)"sysimport:crosswalk")) {
                this.incrementCounter(rd + "_collected");
            } else if (StringUtils.startsWith((String)info.getProvenanceaction().getClassid(), (String)"user:")) {
                this.incrementCounter(rd + "_claimed");
            }
            LinkDescriptor ld = this.entityConfigTable.getDescriptor(relDecoder.getTargetType(this.mainEntity.getEntity().getType()), relDescriptor);
            String relId = ld != null && !ld.isSymmetric() ? relDecoder.getRelTargetId() : relDecoder.getRelSourceId();
            rels.add(this.templateFactory.getRel(targetType, relId, Sets.newHashSet((Iterable)metadata), semanticclass, semanticscheme, info.getInferred(), info.getTrust(), info.getInferenceprovenance(), info.getProvenanceaction().getClassid()));
        }
        return rels;
    }

    private List<String> listChildren() {
        ArrayList children = Lists.newArrayList();
        for (OafDecoder decoder : this.children) {
            OafProtos.OafEntity cachedTarget = decoder.getOafRel().getCachedTarget();
            this.addChildren(children, cachedTarget, decoder.getRelDescriptor());
        }
        OafEntityDecoder entity = this.mainEntity.decodeEntity();
        if (entity.getType().equals((Object)TypeProtos.Type.result)) {
            for (ResultProtos.Result.Instance instance : ((ResultProtos.Result)entity.getEntity()).getInstanceList()) {
                children.add(this.templateFactory.getInstance(instance.getHostedby().getKey(), this.listFields((GeneratedMessage)instance, instanceFilter, false, false), MappedCollection.listMap((Iterable)instance.getUrlList(), identifier -> this.templateFactory.getWebResource((String)identifier))));
            }
            for (ResultProtos.Result.ExternalReference er : ((ResultProtos.Result)entity.getEntity()).getExternalReferenceList()) {
                List<String> fields = this.listFields((GeneratedMessage)er, null, false, false);
                children.add(this.templateFactory.getChild("externalreference", null, fields));
            }
        }
        return children;
    }

    private void addChildren(List<String> children, OafProtos.OafEntity target, RelDescriptor relDescriptor) {
        OafEntityDecoder decoder = OafEntityDecoder.decode((OafProtos.OafEntity)target);
        this.incrementCounter(relDescriptor.getSubRelType().toString());
        Predicate<String> filter = this.entityConfigTable.getIncludeFilter(target.getType(), relDescriptor);
        children.add(this.templateFactory.getChild(decoder.getType().toString(), decoder.getId(), this.listFields(decoder.getMetadata(), filter, this.childDefaults, false)));
    }

    private List<String> listFields(GeneratedMessage fields, final Predicate<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        if (fields != null) {
            final HashSet seen = Sets.newHashSet();
            Map<Descriptors.FieldDescriptor, Object> filtered = this.filterFields(fields, filter);
            for (Map.Entry<Descriptors.FieldDescriptor, Object> e : filtered.entrySet()) {
                String name = e.getKey().getName();
                seen.add(name);
                this.addFieldValue(metadata, e.getKey(), e.getValue(), expandingRel);
            }
            if (defaults) {
                Iterable unseen = Iterables.filter((Iterable)fields.getDescriptorForType().getFields(), (Predicate)new Predicate<Descriptors.FieldDescriptor>(){

                    public boolean apply(Descriptors.FieldDescriptor fd) {
                        return !seen.contains(fd.getName()) && filter.apply((Object)fd.getName());
                    }
                });
                for (Descriptors.FieldDescriptor fd : unseen) {
                    this.addFieldValue(metadata, fd, this.getDefault(fd), expandingRel);
                }
            }
        }
        return metadata;
    }

    private Object getDefault(Descriptors.FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOL: {
                return false;
            }
            case BYTES: {
                return "".getBytes();
            }
            case MESSAGE: {
                if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                    return this.defaultQualifier();
                }
                if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.StructuredProperty.newBuilder().setValue("").setQualifier(this.defaultQualifier()).build();
                }
                if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.KeyValue.newBuilder().setKey("").setValue("").build();
                }
                if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.StringField.newBuilder().setValue("").build();
                }
                if (FieldTypeProtos.BoolField.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.BoolField.newBuilder().buildPartial();
                }
                return null;
            }
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FIXED32: 
            case FIXED64: 
            case FLOAT: {
                return 0;
            }
            case STRING: {
                return "";
            }
        }
        return null;
    }

    private FieldTypeProtos.Qualifier defaultQualifier() {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid("").setClassname("").setSchemeid("").setSchemename("").build();
    }

    private void addFieldValue(List<String> metadata, Descriptors.FieldDescriptor fd, Object value, boolean expandingRel) {
        if ("dateofcollection".equals(fd.getName()) || "dateoftransformation".equals(fd.getName()) || "id".equals(fd.getName()) || value == null) {
            return;
        }
        if (fd.getName().equals("datasourcetype")) {
            String classid = ((FieldTypeProtos.Qualifier)value).getClassid();
            FieldTypeProtos.Qualifier.Builder q = FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)((FieldTypeProtos.Qualifier)value));
            if (this.specialDatasourceTypes.contains(classid)) {
                q.setClassid("other").setClassname("other");
            }
            metadata.add(this.asXmlElement("datasourcetypeui", "", q.build(), null));
        }
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.guessType(metadata, fd, o, expandingRel);
            }
        } else {
            this.guessType(metadata, fd, value, expandingRel);
        }
    }

    private void guessType(List<String> metadata, Descriptors.FieldDescriptor fd, Object o, boolean expandingRel) {
        if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            StringBuilder sb;
            if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.Qualifier qualifier = (FieldTypeProtos.Qualifier)o;
                metadata.add(this.asXmlElement(fd.getName(), "", qualifier, null));
            }
            if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.StructuredProperty sp = (FieldTypeProtos.StructuredProperty)o;
                metadata.add(this.asXmlElement(fd.getName(), sp.getValue(), sp.getQualifier(), sp.hasDataInfo() ? sp.getDataInfo() : null));
                if (!expandingRel && fd.getName().equals("pid") && sp.getQualifier().getClassid().equalsIgnoreCase("doi")) {
                    this.incrementCounter("doi");
                }
            }
            if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.KeyValue kv = (FieldTypeProtos.KeyValue)o;
                metadata.add("<" + fd.getName() + " name=\"" + XmlRecordFactory.escapeXml(kv.getValue()) + "\" id=\"" + XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(kv.getKey())) + "\"/>");
            }
            if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                String fieldName = fd.getName();
                if (fieldName.equals("fundingtree")) {
                    String xmlTree;
                    String string = xmlTree = o instanceof FieldTypeProtos.StringField ? ((FieldTypeProtos.StringField)o).getValue() : o.toString();
                    if (expandingRel) {
                        metadata.add(this.getRelFundingTree(xmlTree));
                        this.fillContextMap(xmlTree);
                    } else {
                        metadata.add(xmlTree);
                    }
                } else {
                    FieldTypeProtos.StringField sf = (FieldTypeProtos.StringField)o;
                    StringBuilder sb2 = new StringBuilder("<" + fd.getName());
                    if (sf.hasDataInfo()) {
                        FieldTypeProtos.DataInfo dataInfo = sf.getDataInfo();
                        this.dataInfoAsAttributes(sb2, dataInfo);
                    }
                    sb2.append(">" + XmlRecordFactory.escapeXml(sf.getValue()) + "</" + fd.getName() + ">");
                    metadata.add(sb2.toString());
                }
            }
            if (FieldTypeProtos.BoolField.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.BoolField bf = (FieldTypeProtos.BoolField)o;
                sb = new StringBuilder("<" + fd.getName());
                if (bf.hasDataInfo()) {
                    FieldTypeProtos.DataInfo dataInfo = bf.getDataInfo();
                    this.dataInfoAsAttributes(sb, dataInfo);
                }
                sb.append(">" + (bf.hasValue() ? Boolean.valueOf(bf.getValue()) : "") + "</" + fd.getName() + ">");
                metadata.add(sb.toString());
            }
            if (ResultProtos.Result.Journal.getDescriptor().equals(fd.getMessageType()) && o != null) {
                ResultProtos.Result.Journal j = (ResultProtos.Result.Journal)o;
                metadata.add("<journal issn=\"" + XmlRecordFactory.escapeXml(j.getIssnPrinted()) + "\" eissn=\"" + XmlRecordFactory.escapeXml(j.getIssnOnline()) + "\" lissn=\"" + XmlRecordFactory.escapeXml(j.getIssnLinking()) + "\" ep=\"" + XmlRecordFactory.escapeXml(j.getEp()) + "\" iss=\"" + XmlRecordFactory.escapeXml(j.getIss()) + "\" sp=\"" + XmlRecordFactory.escapeXml(j.getSp()) + "\" vol=\"" + XmlRecordFactory.escapeXml(j.getVol()) + "\">" + XmlRecordFactory.escapeXml(j.getName()) + "</journal>");
            }
            if (ResultProtos.Result.Context.getDescriptor().equals(fd.getMessageType()) && o != null) {
                this.contextes.add(((ResultProtos.Result.Context)o).getId());
            }
            if (FieldTypeProtos.ExtraInfo.getDescriptor().equals(fd.getMessageType()) && o != null) {
                FieldTypeProtos.ExtraInfo e = (FieldTypeProtos.ExtraInfo)o;
                sb = new StringBuilder("<" + fd.getName() + " ");
                sb.append("name=\"" + e.getName() + "\" ");
                sb.append("typology=\"" + e.getTypology() + "\" ");
                sb.append("provenance=\"" + e.getProvenance() + "\" ");
                sb.append("trust=\"" + e.getTrust() + "\"");
                sb.append(">");
                sb.append(e.getValue());
                sb.append("</" + fd.getName() + ">");
                this.extraInfo.add(sb.toString());
            }
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            if (fd.getFullName().equals("eu.dnetlib.data.proto.OafEntity.type")) {
                return;
            }
            metadata.add(this.asXmlElement(fd.getName(), ((Descriptors.EnumValueDescriptor)o).getName(), null, null));
        } else {
            metadata.add(this.asXmlElement(fd.getName(), o.toString(), null, null));
        }
    }

    private StringBuilder dataInfoAsAttributes(StringBuilder sb, FieldTypeProtos.DataInfo dataInfo) {
        sb.append(" inferred=\"" + dataInfo.getInferred() + "\"");
        sb.append(" inferenceprovenance=\"" + dataInfo.getInferenceprovenance() + "\"");
        sb.append(" provenanceaction=\"" + dataInfo.getProvenanceaction().getClassid() + "\"");
        sb.append(" trust=\"" + dataInfo.getTrust() + "\" ");
        return sb;
    }

    private List<String> buildContexts(TypeProtos.Type type) {
        ArrayList res = Lists.newArrayList();
        if (this.contextMapper != null && !this.contextMapper.isEmpty() && type.equals((Object)TypeProtos.Type.result)) {
            XMLTag document = XMLDoc.newDocument((boolean)true).addRoot("contextRoot");
            for (String context : this.contextes) {
                String id = "";
                for (String token : Splitter.on((String)"::").split((CharSequence)context)) {
                    ContextDef def = (ContextDef)this.contextMapper.get(id = id + token);
                    if (def == null) {
                        throw new IllegalStateException(String.format("cannot find context for id '%s'", id));
                    }
                    if (def.getName().equals("context")) {
                        String xpath = "//context/@id='" + def.getId() + "'";
                        if (!document.gotoRoot().rawXpathBoolean(xpath, new Object[]{new Object()}).booleanValue()) {
                            document = this.addContextDef(document.gotoRoot(), def);
                        }
                    }
                    if (def.getName().equals("category")) {
                        String rootId = StringUtils.substringBefore((String)def.getId(), (String)"::");
                        document = this.addContextDef(document.gotoRoot().gotoTag("//context[./@id='" + rootId + "']", new Object[]{new Object()}), def);
                    }
                    if (def.getName().equals("concept")) {
                        document = this.addContextDef(document, def).gotoParent();
                    }
                    id = id + "::";
                }
            }
            for (Element x : document.gotoRoot().getChildElement()) {
                try {
                    res.add(this.asStringElement(x));
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return res;
    }

    private XMLTag addContextDef(XMLTag tag, ContextDef def) {
        tag.addTag(def.getName()).addAttribute("id", def.getId()).addAttribute("label", def.getLabel());
        if (def.getType() != null && !def.getType().isEmpty()) {
            tag.addAttribute("type", def.getType());
        }
        return tag;
    }

    private String asStringElement(Element element) throws TransformerException {
        StringWriter buffer = new StringWriter();
        this.transformer.transform(new DOMSource(element), new StreamResult(buffer));
        return buffer.toString();
    }

    private String getRelFundingTree(String xmlTree) {
        String funding = "<funding>";
        try {
            Document ftree = new SAXReader().read((Reader)new StringReader(xmlTree));
            funding = "<funding>";
            funding = funding + this.getFunderElement(ftree);
            for (Object o : Lists.reverse((List)ftree.selectNodes("//fundingtree//*[starts-with(local-name(),'funding_level_')]"))) {
                org.dom4j.Element e = (org.dom4j.Element)o;
                String _id = e.valueOf("./id");
                funding = funding + "<" + e.getName() + " name=\"" + XmlRecordFactory.escapeXml(e.valueOf("./name")) + "\">" + XmlRecordFactory.escapeXml(_id) + "</" + e.getName() + ">";
            }
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("unable to parse funding tree: " + xmlTree + "\n" + e.getMessage());
        }
        finally {
            funding = funding + "</funding>";
        }
        return funding;
    }

    private String getFunderElement(Document ftree) {
        String funderId = ftree.valueOf("//fundingtree/funder/id/text()");
        String funderShortName = ftree.valueOf("//fundingtree/funder/shortname/text()");
        String funderName = ftree.valueOf("//fundingtree/funder/name/text()");
        String funderJurisdiction = ftree.valueOf("//fundingtree/funder/jurisdiction/text()");
        return "<funder id=\"" + XmlRecordFactory.escapeXml(funderId) + "\" shortname=\"" + XmlRecordFactory.escapeXml(funderShortName) + "\" name=\"" + XmlRecordFactory.escapeXml(funderName) + "\" jurisdiction=\"" + XmlRecordFactory.escapeXml(funderJurisdiction) + "\" />";
    }

    private void fillContextMap(String xmlTree) {
        Document fundingPath;
        try {
            fundingPath = new SAXReader().read((Reader)new StringReader(xmlTree));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        try {
            Node funder = fundingPath.selectSingleNode("//funder");
            if (funder != null) {
                String funderShortName = funder.valueOf("./shortname");
                this.contextes.add(funderShortName);
                this.contextMapper.put(funderShortName, new ContextDef(funderShortName, funder.valueOf("./name"), "context", "funding"));
                Node level0 = fundingPath.selectSingleNode("//funding_level_0");
                if (level0 != null) {
                    String level0Id = Joiner.on((String)"::").join((Object)funderShortName, (Object)level0.valueOf("./name"), new Object[0]);
                    this.contextMapper.put(level0Id, new ContextDef(level0Id, level0.valueOf("./description"), "category", ""));
                    Node level1 = fundingPath.selectSingleNode("//funding_level_1");
                    if (level1 == null) {
                        this.contextes.add(level0Id);
                    } else {
                        String level1Id = Joiner.on((String)"::").join((Object)level0Id, (Object)level1.valueOf("./name"), new Object[0]);
                        this.contextMapper.put(level1Id, new ContextDef(level1Id, level1.valueOf("./description"), "concept", ""));
                        Node level2 = fundingPath.selectSingleNode("//funding_level_2");
                        if (level2 == null) {
                            this.contextes.add(level1Id);
                        } else {
                            String level2Id = Joiner.on((String)"::").join((Object)level1Id, (Object)level2.valueOf("./name"), new Object[0]);
                            this.contextMapper.put(level2Id, new ContextDef(level2Id, level2.valueOf("./description"), "concept", ""));
                            this.contextes.add(level2Id);
                        }
                    }
                }
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("malformed funding path: " + xmlTree, e);
        }
    }

    private String asXmlElement(String name, String value, FieldTypeProtos.Qualifier q, FieldTypeProtos.DataInfo dataInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        if (q != null) {
            sb.append(this.getAttributes(q));
        }
        if (dataInfo != null) {
            sb = this.dataInfoAsAttributes(sb, dataInfo);
        }
        if (value == null || value.isEmpty()) {
            sb.append("/>");
            return sb.toString();
        }
        sb.append(">");
        sb.append(XmlRecordFactory.escapeXml(value));
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    private String getAttributes(FieldTypeProtos.Qualifier q) {
        if (q == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : q.getAllFields().entrySet()) {
            sb.append(" ");
            sb.append(((Descriptors.FieldDescriptor)e.getKey()).getName());
            sb.append("=\"");
            sb.append(XmlRecordFactory.escapeXml(e.getValue().toString()));
            sb.append("\"");
        }
        return sb.toString();
    }

    private Map<Descriptors.FieldDescriptor, Object> filterFields(GeneratedMessage fields, Predicate<String> acceptFilter) {
        if (acceptFilter == null) {
            return fields.getAllFields();
        }
        HashMap res = Maps.newHashMap();
        for (Map.Entry e : fields.getAllFields().entrySet()) {
            if (!acceptFilter.apply((Object)((Descriptors.FieldDescriptor)e.getKey()).getName())) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private List<String> countersAsXml() {
        ArrayList out = Lists.newArrayList();
        for (Map.Entry<String, Integer> e : this.counters.entrySet()) {
            out.add(String.format("<counter_%s value=\"%s\"/>", e.getKey(), e.getValue()));
        }
        return out;
    }

    private void incrementCounter(String type) {
        if (!this.counters.containsKey(type)) {
            this.counters.put(type, 1);
        } else {
            this.counters.put(type, this.counters.get(type) + 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("################################################\n");
        sb.append("ID: ").append(this.key).append("\n");
        if (this.mainEntity != null) {
            sb.append("MAIN ENTITY:\n").append(this.mainEntity.getEntity().toString() + "\n");
        }
        if (this.relations != null) {
            sb.append("\nRELATIONS:\n");
            for (OafDecoder decoder : this.relations) {
                sb.append(decoder.getOafRel().toString() + "\n");
            }
        }
        if (this.children != null) {
            sb.append("\nCHILDREN:\n");
            for (OafDecoder decoder : this.children) {
                sb.append(decoder.getOafRel().toString() + "\n");
            }
        }
        return sb.toString();
    }
}

