/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class AbstractEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        new AbstractEventFactory().processAbstract(context, current, other, trust);
    }

    private void processAbstract(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust) throws IOException, InterruptedException, DocumentException {
        if (this.hasAbstract(other) && !this.hasAbstract(current)) {
            this.doProcessAbstract(context, current, other, Topic.ENRICH_MISSING_ABSTRACT, trust);
        }
    }

    private void doProcessAbstract(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        List descriptionList = other.getEntity().getResult().getMetadata().getDescriptionList();
        prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().addAllDescription((Iterable)descriptionList);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichAbstract(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), descriptionList);
        EventMessage event = EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust);
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }

    private boolean hasAbstract(OafProtos.Oaf oaf) {
        return Iterables.any((Iterable)oaf.getEntity().getResult().getMetadata().getDescriptionList(), (Predicate)new Predicate<FieldTypeProtos.StringField>(){

            public boolean apply(FieldTypeProtos.StringField s) {
                return StringUtils.isNotBlank((String)s.getValue());
            }
        });
    }
}

