/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class OAVersionEventFactory {
    protected Text tKey = new Text("");

    public static void process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust, Set<String> untrustedOaDsList) throws IOException, InterruptedException, DocumentException {
        new OAVersionEventFactory().processOAVersion(context, current, other, trust, untrustedOaDsList);
    }

    private void processOAVersion(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, float trust, Set<String> untrustedOaDsList) throws IOException, InterruptedException, DocumentException {
        String otherDsId = StringUtils.substringAfter((String)OafHbaseUtils.getKey(other.getEntity().getCollectedfromList()), (String)"|");
        if (!untrustedOaDsList.contains(otherDsId) && this.hasAccess(other, "OPEN", false)) {
            this.doProcessOAVersion(context, current, other, Topic.ENRICH_MORE_OA_VERSION, trust);
            if (!this.hasAccess(current, "OPEN", true)) {
                this.doProcessOAVersion(context, current, other, Topic.ENRICH_MISSING_OA_VERSION, trust);
            }
        }
    }

    private void doProcessOAVersion(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        List<ResultProtos.Result.Instance> instances = other.getEntity().getResult().getInstanceList().stream().filter(i -> "OPEN".equalsIgnoreCase(i.getAccessright().getClassid())).collect(Collectors.toList());
        prototype.getEntityBuilder().getResultBuilder().addAllInstance(instances);
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichOa(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), instances);
        EventMessage event = EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust);
        context.write((Object)this.tKey, (Object)new Text(event.toString()));
        context.getCounter("event", topic.getValue()).increment(1L);
    }

    private boolean hasAccess(OafProtos.Oaf oaf, String access, boolean strict) {
        Predicate p = i -> access.equalsIgnoreCase(i.getAccessright().getClassid());
        List i2 = oaf.getEntity().getResult().getInstanceList();
        return strict ? Iterables.all((Iterable)i2, (Predicate)p) : Iterables.any((Iterable)i2, (Predicate)p);
    }
}

