/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DeleteActionsMapper
extends TableMapper<ImmutableBytesWritable, Delete> {
    private String set = null;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.set = context.getConfiguration().get("set");
        if (this.set != null) {
            System.out.println("Deleting set: " + this.set);
        } else {
            System.out.println("Deleting ALL sets");
        }
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.set == null || value.getColumnLatest(Bytes.toBytes((String)"set"), Bytes.toBytes((String)this.set)) != null) {
            byte[] rowKey = key.copyBytes();
            System.out.println("Deleting action " + Bytes.toString((byte[])rowKey));
            context.getCounter("Actions", "N. Deletes").increment(1L);
            context.write((Object)key, (Object)new Delete(rowKey));
        }
    }
}

