/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.XsltRowTransformer;
import eu.dnetlib.data.transform.XsltRowTransformerFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ImportRecordsMapper
extends Mapper<Text, Text, ImmutableBytesWritable, Put> {
    private static final Log log = LogFactory.getLog(ImportRecordsMapper.class);
    private XsltRowTransformer transformer;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String xslt = context.getConfiguration().get("hbase.import.xslt").trim();
        if (xslt == null || xslt.isEmpty()) {
            throw new IllegalArgumentException("missing xslt");
        }
        HashMap xslParams = Maps.newHashMap();
        if (context.getConfiguration().get("datasourceTypeMap") != null) {
            Map<String, String> dsMap = this.getDatasourceTypeMap(context);
            log.info((Object)("using datasource type map:\n" + dsMap.toString()));
            xslParams.put("mergeIdForHomonymsMap", dsMap);
        }
        this.transformer = XsltRowTransformerFactory.newInstance((String)xslt, (Map)xslParams);
        this.ibw = new ImmutableBytesWritable();
        log.info((Object)("got xslt: '" + xslt));
        log.info((Object)("using trasformer: '" + this.transformer.getTransformerClassName() + "'"));
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            for (Row row : this.transformer.apply(value.toString())) {
                byte[] rowKey = Bytes.toBytes((String)row.getKey());
                Put put = new Put(rowKey);
                put.setWriteToWAL(true);
                for (Column col : row) {
                    byte[] family = Bytes.toBytes((String)row.getColumnFamily());
                    byte[] qualifier = Bytes.toBytes((String)((String)col.getName()));
                    put.add(family, qualifier, (byte[])col.getValue());
                }
                this.ibw.set(rowKey);
                context.write((Object)this.ibw, (Object)put);
                context.getCounter("mdstore", row.getColumnFamily()).increment((long)row.getColumns().size());
            }
        }
        catch (Throwable e) {
            log.error((Object)("error importing the following record on HBase: " + value.toString()), e);
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getDatasourceTypeMap(Mapper.Context context) {
        String dsType = context.getConfiguration().get("datasourceTypeMap");
        Type token = new TypeToken<Map<String, String>>(){}.getType();
        Map dsMap = (Map)new Gson().fromJson(dsType, token);
        return dsMap;
    }
}

