/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ImportInformationSpaceDumpMapper
extends Mapper<Text, Text, ImmutableBytesWritable, Put> {
    private static final Log log = LogFactory.getLog(ImportInformationSpaceDumpMapper.class);
    private static final String SEPARATOR = "@";
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            String[] split = key.toString().split(SEPARATOR);
            if (split.length != 3) {
                throw new IllegalArgumentException("malformed key: " + key.toString());
            }
            byte[] rowKey = Bytes.toBytes((String)split[0]);
            byte[] columnFamily = Bytes.toBytes((String)split[1]);
            byte[] qualifier = Bytes.toBytes((String)split[2]);
            Put put = new Put(rowKey);
            put.setWriteToWAL(true);
            this.ibw.set(rowKey);
            if (StringUtils.isNotBlank((String)value.toString())) {
                OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
                JsonFormat.merge((CharSequence)value.toString(), (Message.Builder)oaf);
                put.add(columnFamily, qualifier, oaf.build().toByteArray());
            } else {
                put.add(columnFamily, qualifier, Bytes.toBytes((String)""));
            }
            context.write((Object)this.ibw, (Object)put);
        }
        catch (Throwable e) {
            log.error((Object)String.format("error importing the following record on HBase: \nkey: '%s'\nvalue: %s", key.toString(), value.toString()), e);
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }
}

