/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.experiment;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.Set;

public class CsvEntry {
    private String key;
    private Set<String> features = Sets.newLinkedHashSet();
    private String title;
    private String id;
    private String originalName;

    public CsvEntry() {
    }

    public CsvEntry(String key, Set<String> features) {
        this.key = key;
        this.features = features;
    }

    public CsvEntry(Set<String> features) {
        this.features = features;
    }

    public void addFeature(String f) {
        this.getFeatures().add(f);
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Set<String> features) {
        this.features = features;
    }

    public static CsvEntry fromJson(String json) {
        return (CsvEntry)new Gson().fromJson(json, CsvEntry.class);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        return o instanceof CsvEntry && ((CsvEntry)o).getFeatures().equals(this.getFeatures());
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }
}

